/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.plink.readers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Iterator;
import org.molgenis.genotype.plink.PlinkFileParser;
import org.molgenis.genotype.plink.datatypes.MapEntry;
import org.molgenis.genotype.plink.drivers.MapFileDriver;

public class MapFileReader
implements PlinkFileParser,
Iterable<MapEntry> {
    private static final Charset CHARSET_UTF8 = Charset.forName("UTF-8");
    private final BufferedReader reader;
    private final String separators;

    public MapFileReader(InputStream in) {
        this(in, " \t");
    }

    public MapFileReader(InputStream in, char separator) {
        this(in, String.valueOf(separator));
    }

    public MapFileReader(InputStream in, String separators) {
        this.reader = new BufferedReader(new InputStreamReader(in, CHARSET_UTF8));
        this.separators = separators;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public Iterator<MapEntry> iterator() {
        return new MapFileIterator();
    }

    private class MapFileIterator
    implements Iterator<MapEntry> {
        private String line;

        public MapFileIterator() {
            try {
                this.line = MapFileReader.this.reader.readLine();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean hasNext() {
            return this.line != null;
        }

        @Override
        public MapEntry next() {
            MapEntry entry;
            try {
                entry = MapFileDriver.parseEntry(this.line, MapFileReader.this.separators);
                this.line = MapFileReader.this.reader.readLine();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

