/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.plink.drivers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.molgenis.genotype.plink.PlinkFileParser;
import org.molgenis.genotype.plink.datatypes.MapEntry;

public class MapFileDriver
implements PlinkFileParser {
    private BufferedReader reader;
    private final File file;
    private final String separators;
    private long nrElements;

    public MapFileDriver(File mapFile) {
        this(mapFile, " \t");
    }

    public MapFileDriver(File mapFile, char separator) {
        this(mapFile, String.valueOf(separator));
    }

    public MapFileDriver(File mapFile, String separators) {
        if (mapFile == null) {
            throw new IllegalArgumentException("file is null");
        }
        this.file = mapFile;
        this.separators = separators;
        this.nrElements = -1L;
    }

    public List<MapEntry> getEntries(long from, long to) throws IOException {
        String line;
        this.reset();
        ArrayList<MapEntry> entryList = new ArrayList<MapEntry>();
        int i = 0;
        while ((line = this.reader.readLine()) != null && (long)i < to) {
            if ((long)i >= from) {
                entryList.add(MapFileDriver.parseEntry(line, this.separators));
            }
            ++i;
        }
        return entryList;
    }

    public List<MapEntry> getAllEntries() throws IOException {
        String line;
        this.reset();
        ArrayList<MapEntry> entryList = new ArrayList<MapEntry>();
        while ((line = this.reader.readLine()) != null) {
            entryList.add(MapFileDriver.parseEntry(line, this.separators));
        }
        return entryList;
    }

    public static MapEntry parseEntry(String line, String separators) throws IOException {
        StringTokenizer strTokenizer = new StringTokenizer(line, separators);
        try {
            String chromosome = strTokenizer.nextToken();
            String snp = strTokenizer.nextToken();
            double cM = Double.parseDouble(strTokenizer.nextToken());
            long bpPos = Long.parseLong(strTokenizer.nextToken());
            return new MapEntry(chromosome, snp, cM, bpPos);
        }
        catch (NoSuchElementException e) {
            throw new IOException("error in line: " + line, e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IOException("error in line: " + line, e);
        }
        catch (NumberFormatException e) {
            throw new IOException("error in line: " + line, e);
        }
    }

    public long getNrOfElements() throws IOException {
        if (this.nrElements == -1L) {
            this.nrElements = MapFileDriver.getNumberOfNonEmptyLines(this.file, FILE_ENCODING);
        }
        return this.nrElements;
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    public void reset() throws IOException {
        if (this.reader != null) {
            this.close();
        }
        this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), FILE_ENCODING));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getNumberOfNonEmptyLines(File file, Charset charset) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));){
            String line;
            int count = 0;
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty()) continue;
                ++count;
            }
            int n = count;
            return n;
        }
    }
}

