/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.plink.datatypes;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.molgenis.genotype.Alleles;

public class PedEntry
implements Iterable<Alleles> {
    private final Iterator<Alleles> bialleles;
    private final String family;
    private final String individual;
    private final String father;
    private final String mother;
    private final byte sex;
    private final double phenotype;

    public PedEntry(String family, String individual, String father, String mother, byte sex, double phenotype, Iterator<Alleles> bialleles) {
        this.family = family;
        this.individual = individual;
        this.father = father;
        this.mother = mother;
        this.sex = sex;
        this.phenotype = phenotype;
        this.bialleles = bialleles;
    }

    @Override
    public Iterator<Alleles> iterator() {
        return this.bialleles;
    }

    public List<Alleles> getBialleles() {
        ArrayList<Alleles> bialleleList = new ArrayList<Alleles>();
        Iterator<Alleles> it = this.iterator();
        while (it.hasNext()) {
            bialleleList.add(it.next());
        }
        return bialleleList;
    }

    public String getFamily() {
        return this.family;
    }

    public String getIndividual() {
        return this.individual;
    }

    public String getFather() {
        return this.father;
    }

    public String getMother() {
        return this.mother;
    }

    public byte getSex() {
        return this.sex;
    }

    public double getPhenotype() {
        return this.phenotype;
    }
}

