/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.oxford;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.molgenis.genotype.AbstractRandomAccessGenotypeData;
import org.molgenis.genotype.Allele;
import org.molgenis.genotype.Alleles;
import org.molgenis.genotype.GenotypeDataException;
import org.molgenis.genotype.Sample;
import org.molgenis.genotype.Sequence;
import org.molgenis.genotype.SimpleSequence;
import org.molgenis.genotype.annotation.Annotation;
import org.molgenis.genotype.annotation.SampleAnnotation;
import org.molgenis.genotype.oxford.OxfordSampleFile;
import org.molgenis.genotype.util.CalledDosageConvertor;
import org.molgenis.genotype.util.FixedSizeIterable;
import org.molgenis.genotype.util.ProbabilitiesConvertor;
import org.molgenis.genotype.util.RecordIteratorCreators;
import org.molgenis.genotype.variant.GeneticVariant;
import org.molgenis.genotype.variant.GeneticVariantMeta;
import org.molgenis.genotype.variant.GeneticVariantMetaMap;
import org.molgenis.genotype.variant.GenotypeRecord;
import org.molgenis.genotype.variant.ReadOnlyGeneticVariant;
import org.molgenis.genotype.variant.range.GeneticVariantRange;
import org.molgenis.genotype.variant.sampleProvider.CachedSampleVariantProvider;
import org.molgenis.genotype.variant.sampleProvider.SampleVariantUniqueIdProvider;
import org.molgenis.genotype.variant.sampleProvider.SampleVariantsProvider;

public class HapsGenotypeData
extends AbstractRandomAccessGenotypeData
implements SampleVariantsProvider {
    private final RandomAccessFile hapsFileReader;
    private Map<String, SampleAnnotation> sampleAnnotations;
    private final int sampleVariantProviderUniqueId;
    private final SampleVariantsProvider sampleVariantProvider;
    private final GeneticVariantRange variants;
    private final LinkedHashMap<GeneticVariant, Long> variantSampleAllelesIndex;
    private final List<Sample> samples;
    private final HashSet<String> sequenceNames;
    private final int byteToReadForSampleAlleles;
    private static final Logger LOGGER = Logger.getLogger(HapsGenotypeData.class);
    private AllelesAndPhasing last;
    private GeneticVariantMeta geneticVariantMeta = GeneticVariantMetaMap.getGeneticVariantMetaGt();

    public HapsGenotypeData(String path) throws IOException {
        this(new File(path + ".haps"), new File(path + ".sample"));
    }

    public HapsGenotypeData(File hapsFile, File sampleFile) throws IOException {
        this(hapsFile, sampleFile, 100);
    }

    public HapsGenotypeData(File hapsFile, File sampleFile, int cacheSize) throws IOException {
        this(hapsFile, sampleFile, cacheSize, null);
    }

    public HapsGenotypeData(File hapsFile, File sampleFile, String forceSeqName) throws IOException {
        this(hapsFile, sampleFile, 100, forceSeqName);
    }

    public HapsGenotypeData(File hapsFile, File sampleFile, int cacheSize, String forceSeqName) throws IOException {
        if (hapsFile == null) {
            throw new IllegalArgumentException("hapsFile is null");
        }
        if (!hapsFile.isFile()) {
            throw new FileNotFoundException("haps file file not found at " + hapsFile.getAbsolutePath());
        }
        if (!hapsFile.canRead()) {
            throw new IOException("Can not read haps file at " + hapsFile.getAbsolutePath());
        }
        this.sampleVariantProviderUniqueId = SampleVariantUniqueIdProvider.getNextUniqueId();
        this.sampleVariantProvider = cacheSize > 0 ? new CachedSampleVariantProvider(this, cacheSize) : this;
        OxfordSampleFile oxfordSampleFile = new OxfordSampleFile(sampleFile);
        this.sampleAnnotations = oxfordSampleFile.getSampleAnnotations();
        this.samples = oxfordSampleFile.getSamples();
        GeneticVariantRange.GeneticVariantRangeCreate variantRangeFactory = GeneticVariantRange.createRangeFactory();
        this.variantSampleAllelesIndex = new LinkedHashMap();
        this.sequenceNames = new HashSet();
        this.hapsFileReader = new RandomAccessFile(hapsFile, "r");
        this.byteToReadForSampleAlleles = this.loadVariants(forceSeqName, variantRangeFactory);
        this.variants = variantRangeFactory.createRange();
    }

    @Override
    public Iterable<Sequence> getSequences() {
        ArrayList<Sequence> sequences = new ArrayList<Sequence>();
        for (String seqName : this.getSeqNames()) {
            sequences.add(new SimpleSequence(seqName, null, this));
        }
        return sequences;
    }

    @Override
    public List<Sample> getSamples() {
        return Collections.unmodifiableList(this.samples);
    }

    @Override
    public Map<String, Annotation> getVariantAnnotationsMap() {
        return Collections.emptyMap();
    }

    @Override
    public Map<String, SampleAnnotation> getSampleAnnotationsMap() {
        return this.sampleAnnotations;
    }

    @Override
    public synchronized List<Alleles> getSampleVariants(GeneticVariant variant) {
        if (this.last == null || !this.last.getVariant().equals(variant)) {
            this.last = this.loadAllelesAndPhasing(variant);
        }
        return this.last.getAlleles();
    }

    @Override
    public synchronized List<Boolean> getSamplePhasing(GeneticVariant variant) {
        if (this.last == null || !this.last.getVariant().equals(variant)) {
            this.last = this.loadAllelesAndPhasing(variant);
        }
        return this.last.getPhasing();
    }

    @Override
    public int cacheSize() {
        return 0;
    }

    @Override
    public int getSampleVariantProviderUniqueId() {
        return this.sampleVariantProviderUniqueId;
    }

    @Override
    public byte[] getSampleCalledDosage(GeneticVariant variant) {
        return CalledDosageConvertor.convertCalledAllelesToCalledDosage(this.getSampleVariants(variant), variant.getVariantAlleles(), variant.getRefAllele());
    }

    @Override
    public float[] getSampleDosage(GeneticVariant variant) {
        return CalledDosageConvertor.convertCalledAllelesToDosage(this.getSampleVariants(variant), variant.getVariantAlleles(), variant.getRefAllele());
    }

    @Override
    public void close() throws IOException {
        this.hapsFileReader.close();
    }

    @Override
    public Iterator<GeneticVariant> iterator() {
        return this.variants.iterator();
    }

    @Override
    public List<String> getSeqNames() {
        return new ArrayList<String>(this.sequenceNames);
    }

    @Override
    public Iterable<GeneticVariant> getVariantsByPos(String seqName, int startPos) {
        return this.variants.getVariantAtPos(seqName, startPos);
    }

    @Override
    public Iterable<GeneticVariant> getSequenceGeneticVariants(String seqName) {
        return this.variants.getVariantsBySequence(seqName);
    }

    @Override
    public Iterable<GeneticVariant> getVariantsByRange(String seqName, int rangeStart, int rangeEnd) {
        return this.variants.getVariantsByRange(seqName, rangeStart, rangeEnd);
    }

    private int loadVariants(String forceSeqName, GeneticVariantRange.GeneticVariantRangeCreate variantRangeFactory) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        byte[] buffer = new byte[8192];
        boolean eol = false;
        String seqName = null;
        String variantId = null;
        int position = 0;
        String allele1 = null;
        int longestedChunk = 0;
        int currentChunk = 0;
        int column = 0;
        while (!eol) {
            long posBeforeBufferRead = this.hapsFileReader.getFilePointer();
            int bytesRead = this.hapsFileReader.read(buffer);
            if (bytesRead == -1) {
                eol = true;
                continue;
            }
            block14: for (int i = 0; i < bytesRead; ++i) {
                block1 : switch (buffer[i]) {
                    case 10: 
                    case 13: {
                        if (currentChunk == 0) {
                            currentChunk = -1;
                            continue block14;
                        }
                        if (column != 5) {
                            LOGGER.fatal("Error reading haps file, did not detect first 5 columns with variant information \ncurrent column is:" + column + "\n" + "content in current column: " + stringBuilder.toString());
                            throw new GenotypeDataException("Error reading haps file, did not detect first 5 columns with variant information");
                        }
                        longestedChunk = longestedChunk < currentChunk ? currentChunk : longestedChunk;
                        column = 0;
                        currentChunk = -1;
                        break;
                    }
                    case 32: {
                        switch (column) {
                            case 0: {
                                seqName = forceSeqName == null ? stringBuilder.toString().intern() : forceSeqName;
                                this.sequenceNames.add(seqName);
                                ++column;
                                stringBuilder = new StringBuilder();
                                break block1;
                            }
                            case 1: {
                                variantId = stringBuilder.toString();
                                ++column;
                                stringBuilder = new StringBuilder();
                                break block1;
                            }
                            case 2: {
                                try {
                                    position = Integer.parseInt(stringBuilder.toString());
                                }
                                catch (NumberFormatException ex) {
                                    throw new GenotypeDataException("Error parsing \"" + stringBuilder.toString() + "\" as position in haps file");
                                }
                                ++column;
                                stringBuilder = new StringBuilder();
                                break block1;
                            }
                            case 3: {
                                allele1 = stringBuilder.toString();
                                ++column;
                                stringBuilder = new StringBuilder();
                                break block1;
                            }
                            case 4: {
                                String allele2 = stringBuilder.toString();
                                GeneticVariant variant = ReadOnlyGeneticVariant.createVariant(this.geneticVariantMeta, variantId, position, seqName, this.sampleVariantProvider, allele1, allele2);
                                variantRangeFactory.addVariant(variant);
                                this.variantSampleAllelesIndex.put(variant, posBeforeBufferRead + (long)i + 1L);
                                ++column;
                                stringBuilder = new StringBuilder();
                                currentChunk = -1;
                                break block1;
                            }
                        }
                        break;
                    }
                    default: {
                        if (column >= 5) break;
                        stringBuilder.append((char)buffer[i]);
                    }
                }
                ++currentChunk;
            }
        }
        return longestedChunk;
    }

    private AllelesAndPhasing loadAllelesAndPhasing(GeneticVariant geneticVariant) {
        int bytesRead;
        ArrayList<Alleles> alleles = new ArrayList<Alleles>();
        ArrayList<Boolean> phasing = new ArrayList<Boolean>();
        Alleles variantAlleles = geneticVariant.getVariantAlleles();
        long start = this.variantSampleAllelesIndex.get(geneticVariant);
        byte[] buffer = new byte[this.byteToReadForSampleAlleles];
        try {
            this.hapsFileReader.seek(start);
            bytesRead = this.hapsFileReader.read(buffer);
        }
        catch (IOException ex) {
            throw new GenotypeDataException("Error loading alleles for variant: " + geneticVariant.getPrimaryVariantId() + " from haps file");
        }
        if (bytesRead == -1) {
            throw new GenotypeDataException("Error loading alleles for variant: " + geneticVariant.getPrimaryVariantId() + " from haps file");
        }
        int i = 0;
        for (int s = 0; s < this.samples.size(); ++s) {
            Allele allele2;
            Boolean phased;
            Allele allele1;
            switch ((char)buffer[i]) {
                case '0': {
                    allele1 = variantAlleles.get(0);
                    break;
                }
                case '1': {
                    allele1 = variantAlleles.get(1);
                    break;
                }
                case '?': {
                    allele1 = Allele.ZERO;
                    break;
                }
                default: {
                    throw new GenotypeDataException("Error loading alleles for variant: " + geneticVariant.getPrimaryVariantId() + " and sample " + this.samples.get(s).getId() + " from haps file found allele: " + (char)buffer[i]);
                }
            }
            switch ((char)buffer[++i]) {
                case ' ': {
                    phased = Boolean.TRUE;
                    break;
                }
                case '*': {
                    phased = Boolean.FALSE;
                    ++i;
                    break;
                }
                default: {
                    throw new GenotypeDataException("Error loading alleles for variant: " + geneticVariant.getPrimaryVariantId() + " and sample " + this.samples.get(s).getId() + " from haps file expected space or * but found: " + (char)buffer[i]);
                }
            }
            switch ((char)buffer[++i]) {
                case '0': {
                    allele2 = variantAlleles.get(0);
                    break;
                }
                case '1': {
                    allele2 = variantAlleles.get(1);
                    break;
                }
                case '?': {
                    allele2 = Allele.ZERO;
                    break;
                }
                default: {
                    throw new GenotypeDataException("Error loading alleles for variant: " + geneticVariant.getPrimaryVariantId() + " and sample " + this.samples.get(s).getId() + " from haps file found allele: " + (char)buffer[i]);
                }
            }
            if (!phased.booleanValue()) {
                ++i;
            }
            ++i;
            ++i;
            alleles.add(Alleles.createAlleles(allele1, allele2));
            phasing.add(phased);
        }
        return new AllelesAndPhasing(geneticVariant, alleles, phasing);
    }

    @Override
    public boolean isOnlyContaingSaveProbabilityGenotypes() {
        return true;
    }

    @Override
    public float[][] getSampleProbilities(GeneticVariant variant) {
        return ProbabilitiesConvertor.convertCalledAllelesToProbability(variant.getSampleVariants(), variant.getVariantAlleles());
    }

    @Override
    public FixedSizeIterable<GenotypeRecord> getSampleGenotypeRecords(GeneticVariant variant) {
        return RecordIteratorCreators.createIteratorFromAlleles(variant.getSampleVariants());
    }

    private static class AllelesAndPhasing {
        private final GeneticVariant variant;
        private final List<Alleles> alleles;
        private final List<Boolean> phasing;

        public AllelesAndPhasing(GeneticVariant variant, List<Alleles> alleles, List<Boolean> phasing) {
            this.variant = variant;
            this.alleles = alleles;
            this.phasing = phasing;
        }

        public List<Alleles> getAlleles() {
            return this.alleles;
        }

        public List<Boolean> getPhasing() {
            return this.phasing;
        }

        public GeneticVariant getVariant() {
            return this.variant;
        }
    }
}

