/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.multipart;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.molgenis.genotype.RandomAccessGenotypeData;
import org.molgenis.genotype.Sequence;

public class MultiPartSequencesIterable
implements Iterable<Sequence> {
    private final Iterable<RandomAccessGenotypeData> datasets;

    public MultiPartSequencesIterable(Iterable<RandomAccessGenotypeData> collection) {
        this.datasets = collection;
    }

    @Override
    public Iterator<Sequence> iterator() {
        return new MultiPartSequencesIterator(this.datasets);
    }

    private static class MultiPartSequencesIterator
    implements Iterator<Sequence> {
        private Iterator<RandomAccessGenotypeData> datasetIterator;
        private Iterator<Sequence> datasetSequenceIterator;
        private boolean done = false;

        public MultiPartSequencesIterator(Iterable<RandomAccessGenotypeData> datasets) {
            this.datasetIterator = datasets.iterator();
            if (this.datasetIterator.hasNext()) {
                this.datasetSequenceIterator = this.datasetIterator.next().getSequences().iterator();
            } else {
                this.done = true;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.done) {
                return false;
            }
            while (!this.datasetSequenceIterator.hasNext()) {
                if (this.datasetIterator.hasNext()) {
                    this.datasetSequenceIterator = this.datasetIterator.next().getSequences().iterator();
                    continue;
                }
                this.done = true;
                return false;
            }
            return true;
        }

        @Override
        public Sequence next() {
            if (this.hasNext()) {
                return this.datasetSequenceIterator.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

