/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.modifiable;

import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.molgenis.genotype.modifiable.ModifiableGeneticVariant;
import org.molgenis.genotype.modifiable.ModifiableGenotypeData;
import org.molgenis.genotype.variant.GeneticVariant;

public class ModifiableGeneticVariantIterator<E extends GeneticVariant>
implements Iterator<E> {
    private final Iterator<GeneticVariant> originalIterator;
    private final ModifiableGenotypeData modifiableGenotypeData;
    private final HashSet<ModifiableGeneticVariant> excludeList;
    private ModifiableGeneticVariant next;

    public ModifiableGeneticVariantIterator(Iterator<GeneticVariant> originalIterator, ModifiableGenotypeData modifiableGenotypeData, HashSet<ModifiableGeneticVariant> excludeList) {
        this.originalIterator = originalIterator;
        this.modifiableGenotypeData = modifiableGenotypeData;
        this.excludeList = excludeList;
        this.goToNext();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public E next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        ModifiableGeneticVariant currentNext = this.next;
        this.goToNext();
        return (E)currentNext;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Removal not supported via iterator.");
    }

    private void goToNext() {
        while (this.originalIterator.hasNext()) {
            ModifiableGeneticVariant originalNext = new ModifiableGeneticVariant(this.originalIterator.next(), this.modifiableGenotypeData);
            if (this.excludeList.contains(originalNext)) continue;
            this.next = originalNext;
            return;
        }
        this.next = null;
    }

    public static Iterable<ModifiableGeneticVariant> createModifiableGeneticVariantIterable(Iterator<GeneticVariant> originalIterator, ModifiableGenotypeData modifiableGenotypeData, HashSet<ModifiableGeneticVariant> excludeList) {
        return new ModifiableGeneticVariantIterable<ModifiableGeneticVariant>(new ModifiableGeneticVariantIterator(originalIterator, modifiableGenotypeData, excludeList));
    }

    public static Iterable<GeneticVariant> createGeneticVariantIterableBackByModifiable(Iterator<GeneticVariant> originalIterator, ModifiableGenotypeData modifiableGenotypeData, HashSet<ModifiableGeneticVariant> excludeList) {
        return new ModifiableGeneticVariantIterable<GeneticVariant>(new ModifiableGeneticVariantIterator(originalIterator, modifiableGenotypeData, excludeList));
    }

    protected static class ModifiableGeneticVariantIterable<E extends GeneticVariant>
    implements Iterable<E> {
        private final Iterator<E> modifiableGeneticVariantIterator;

        public ModifiableGeneticVariantIterable(Iterator<E> modifiableGeneticVariantIterator) {
            this.modifiableGeneticVariantIterator = modifiableGeneticVariantIterator;
        }

        @Override
        public Iterator<E> iterator() {
            return this.modifiableGeneticVariantIterator;
        }
    }
}

