/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.editable;

import org.molgenis.genotype.Alleles;

public class VariantInformation {
    private final String variantId;
    private final int startPos;
    private final String sequenceName;
    private final Alleles alleles;

    public VariantInformation(String variantId, int startPos, String sequenceName, Alleles alleles) {
        this.variantId = variantId;
        this.startPos = startPos;
        this.sequenceName = sequenceName.intern();
        this.alleles = alleles;
    }

    public String getVariantId() {
        return this.variantId;
    }

    public int getStartPos() {
        return this.startPos;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public Alleles getAlleles() {
        return this.alleles;
    }

    public int hashCode() {
        int hash = 3;
        hash = 83 * hash + this.startPos;
        hash = 83 * hash + (this.sequenceName != null ? this.sequenceName.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VariantInformation other = (VariantInformation)obj;
        if (this.startPos != other.startPos) {
            return false;
        }
        if (this.sequenceName == null ? other.sequenceName != null : !this.sequenceName.equals(other.sequenceName)) {
            return false;
        }
        return this.alleles == other.alleles || this.alleles != null && this.alleles.sameAlleles(other.alleles);
    }
}

