/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genotype.editable;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.molgenis.genotype.AbstractRandomAccessGenotypeData;
import org.molgenis.genotype.GenotypeDataException;
import org.molgenis.genotype.Sample;
import org.molgenis.genotype.Sequence;
import org.molgenis.genotype.SimpleSequence;
import org.molgenis.genotype.annotation.Annotation;
import org.molgenis.genotype.annotation.SampleAnnotation;
import org.molgenis.genotype.editable.EditableSampleVariantsProvider;
import org.molgenis.genotype.variant.GeneticVariant;
import org.molgenis.genotype.variant.ReadOnlyGeneticVariant;
import org.molgenis.genotype.variant.range.GeneticVariantRange;

public class GenotypeDataCustomVariantProvider<S extends EditableSampleVariantsProvider>
extends AbstractRandomAccessGenotypeData {
    private final GeneticVariantRange variants;
    private final List samples;
    private static final Logger LOGGER = Logger.getLogger(GenotypeDataCustomVariantProvider.class);
    private final LinkedHashSet<String> sequenceNames;
    private final S sampleVariantProvider;

    public GenotypeDataCustomVariantProvider(Iterable<GeneticVariant> variants, List<Sample> samples, S sampleVariantProvider) {
        this.sampleVariantProvider = sampleVariantProvider;
        this.samples = samples;
        GeneticVariantRange.GeneticVariantRangeCreate variantFactory = GeneticVariantRange.createRangeFactory();
        this.sequenceNames = new LinkedHashSet();
        for (GeneticVariant originalVariant : variants) {
            if (originalVariant.getVariantAlleles().getAlleleCount() != 2) {
                throw new GenotypeDataException("Only biallelic supported");
            }
            GeneticVariant variant = ReadOnlyGeneticVariant.createVariant(this.sampleVariantProvider.getGeneticVariantMeta(), originalVariant.getVariantId(), originalVariant.getStartPos(), originalVariant.getSequenceName(), this.sampleVariantProvider, originalVariant.getVariantAlleles().get(0), originalVariant.getVariantAlleles().get(1));
            variantFactory.addVariant(variant);
            if (this.sequenceNames.contains(variant.getSequenceName())) continue;
            this.sequenceNames.add(variant.getSequenceName());
        }
        this.variants = variantFactory.createRange();
    }

    @Override
    public List<Sample> getSamples() {
        return this.samples;
    }

    @Override
    public Map<String, Annotation> getVariantAnnotationsMap() {
        return Collections.emptyMap();
    }

    @Override
    public Map<String, SampleAnnotation> getSampleAnnotationsMap() {
        return Collections.emptyMap();
    }

    @Override
    public boolean isOnlyContaingSaveProbabilityGenotypes() {
        return true;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public List<String> getSeqNames() {
        return new ArrayList<String>(this.sequenceNames);
    }

    @Override
    public Iterable<Sequence> getSequences() {
        ArrayList<Sequence> sequences = new ArrayList<Sequence>();
        for (String seqName : this.getSeqNames()) {
            sequences.add(new SimpleSequence(seqName, null, this));
        }
        return sequences;
    }

    @Override
    public Iterable<GeneticVariant> getVariantsByPos(String seqName, int startPos) {
        return this.variants.getVariantAtPos(seqName, startPos);
    }

    @Override
    public Iterable<GeneticVariant> getSequenceGeneticVariants(String seqName) {
        return this.variants.getVariantsBySequence(seqName);
    }

    @Override
    public Iterable<GeneticVariant> getVariantsByRange(String seqName, int rangeStart, int rangeEnd) {
        return this.variants.getVariantsByRange(seqName, rangeStart, rangeEnd);
    }

    public S getSampleVariantProvider() {
        return this.sampleVariantProvider;
    }
}

