/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.vcf.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Scanner;
import org.apache.commons.lang.StringUtils;

public class FixVcfAlleleNotation {
    public static void main(String[] args) throws Exception {
        File in = new File(args[0]);
        File out = new File(args[1]);
        try (PrintWriter pw = new PrintWriter(out);
             Scanner s = new Scanner(in);){
            while (s.hasNextLine()) {
                String line = s.nextLine();
                if (line.startsWith("#")) {
                    pw.println(line);
                    continue;
                }
                String[] split = line.split("\t");
                String chr = split[0];
                String pos = split[1];
                String ref = split[3];
                String alt = split[4];
                if (alt.contains(",")) {
                    throw new Exception("multiple alt alleles not supported, stopping at line: " + line);
                }
                String[] trimmedRefAlt = FixVcfAlleleNotation.backTrimRefAlt(ref, alt, "_").split("_");
                if (!ref.equals(trimmedRefAlt[0]) || !alt.equals(trimmedRefAlt[1])) {
                    System.out.println("back-trimming ref/alt, from " + ref + "/" + alt + " to " + trimmedRefAlt[0] + "/" + trimmedRefAlt[1]);
                    ref = trimmedRefAlt[0];
                    alt = trimmedRefAlt[1];
                }
                String[] frontTrimmedRefAlt = FixVcfAlleleNotation.frontTrimRefAlt(ref, alt, "_").split("_");
                int posDiff = ref.length() - frontTrimmedRefAlt[0].length();
                if (!ref.equals(frontTrimmedRefAlt[0]) || !alt.equals(frontTrimmedRefAlt[1])) {
                    System.out.println("front-trimming ref/alt, from " + ref + "/" + alt + " to " + frontTrimmedRefAlt[0] + "/" + frontTrimmedRefAlt[1] + ", position update needed!");
                    ref = frontTrimmedRefAlt[0];
                    alt = frontTrimmedRefAlt[1];
                    pos = Integer.parseInt(pos) + posDiff + "";
                }
                boolean queryUCSC = false;
                if (ref.startsWith("N") && alt.startsWith("N")) {
                    if (ref.startsWith("N") && alt.startsWith("N")) {
                        System.out.println("need to adjust variant " + chr + ":pos " + ref + "/" + alt + " because there is an N");
                        int refNOccurence = org.springframework.util.StringUtils.countOccurrencesOf(ref, "N");
                        int altNOccurence = org.springframework.util.StringUtils.countOccurrencesOf(alt, "N");
                        if (refNOccurence != 1 || altNOccurence != 1) {
                            s.close();
                            pw.close();
                            throw new Exception("expecting 'N' occurence == 1 for " + ref + " and " + alt);
                        }
                        queryUCSC = true;
                    } else {
                        s.close();
                        pw.close();
                        throw new Exception("either ref " + ref + " or alt " + alt + " starts with N, not expected this");
                    }
                }
                String replacementRefBase = "if you see this, we did not get a replacement base while we needed one!";
                if (queryUCSC) {
                    URL ucsc = new URL("http://genome.ucsc.edu/cgi-bin/das/hg19/dna?segment=chr" + chr + ":" + pos + "," + pos);
                    try (BufferedReader getUrlContent = new BufferedReader(new InputStreamReader(ucsc.openStream()));){
                        String urlLine;
                        while ((urlLine = getUrlContent.readLine()) != null) {
                            if (urlLine.length() != 1) continue;
                            replacementRefBase = urlLine.toUpperCase();
                            System.out.println("we found replacement base for N = " + replacementRefBase);
                        }
                        getUrlContent.close();
                        Thread.sleep(100L);
                    }
                }
                StringBuffer fixedLine = new StringBuffer();
                for (int i = 0; i < split.length; ++i) {
                    if (i == 1) {
                        fixedLine.append(pos).append("\t");
                        continue;
                    }
                    if (i == 3 || i == 4) {
                        String fixedNotation = i == 3 ? ref.replace("N", replacementRefBase) : alt.replace("N", replacementRefBase);
                        fixedLine.append(fixedNotation).append("\t");
                        continue;
                    }
                    fixedLine.append(split[i]).append("\t");
                }
                fixedLine.deleteCharAt(fixedLine.length() - 1);
                pw.println(fixedLine);
                pw.flush();
            }
            pw.flush();
            pw.close();
        }
        System.out.println("Done!");
    }

    public static String backTrimRefAlt(String ref, String alt, String sep) {
        char altBase;
        char refBase;
        char[] refRev = StringUtils.reverse(ref).toCharArray();
        char[] altRev = StringUtils.reverse(alt).toCharArray();
        int nrToDelete = 0;
        for (int i = 0; i < refRev.length - 1 && (refBase = refRev[i]) == (altBase = altRev[i]) && altRev.length > i + 1; ++i) {
            ++nrToDelete;
        }
        String newRef = ref.substring(0, ref.length() - nrToDelete);
        String newAlt = alt.substring(0, alt.length() - nrToDelete);
        return newRef + sep + newAlt;
    }

    public static String frontTrimRefAlt(String ref, String alt, String sep) {
        char altBase;
        char refBase;
        char[] refChars = ref.toCharArray();
        char[] altChars = alt.toCharArray();
        int nrToDelete = 0;
        for (int i = 0; i < refChars.length - 1 && (refBase = refChars[i]) == (altBase = altChars[i]) && altChars.length > i + 1 && refChars[i + 1] == altChars[i + 1]; ++i) {
            ++nrToDelete;
        }
        String newRef = ref.substring(nrToDelete, ref.length());
        String newAlt = alt.substring(nrToDelete, alt.length());
        if (nrToDelete > 0) {
            System.out.println("input ref: " + ref + ", alt: " + alt + ", nr to delete: " + nrToDelete + " resulting in:" + newRef + " / " + newAlt);
        }
        return newRef + sep + newAlt;
    }
}

