/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.makervcf.util;

import java.io.File;
import java.io.PrintWriter;
import java.util.Map;
import org.molgenis.calibratecadd.support.LoadCADDWebserviceOutput;
import org.molgenis.data.annotation.makervcf.structs.GavinRecord;
import org.molgenis.data.vcf.utils.FixVcfAlleleNotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandleMissingCaddScores {
    private static final Logger LOG = LoggerFactory.getLogger(HandleMissingCaddScores.class);
    private Mode mode;
    private PrintWriter pw;
    private Map<String, Double> caddScores;

    public HandleMissingCaddScores(Mode mode, File caddFile) throws Exception {
        this.mode = mode;
        if (mode.equals((Object)Mode.CREATEFILEFORCADD)) {
            this.pw = new PrintWriter(caddFile);
        } else if (mode.equals((Object)Mode.ANALYSIS)) {
            this.caddScores = LoadCADDWebserviceOutput.load(caddFile);
        } else {
            throw new Exception("Mode unknown: " + (Object)((Object)mode));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Double dealWithCaddScores(GavinRecord record, int altIndex) throws Exception {
        if (record.getCaddPhredScore(altIndex) != null) return record.getCaddPhredScore(altIndex);
        if (this.mode.equals((Object)Mode.CREATEFILEFORCADD)) {
            String trimmedRefAlt = FixVcfAlleleNotation.backTrimRefAlt(record.getRef(), record.getAlt(altIndex), "\t");
            this.pw.println(record.getChromosome() + "\t" + record.getPosition() + "\t.\t" + trimmedRefAlt);
            this.pw.flush();
            return null;
        }
        if (!this.mode.equals((Object)Mode.ANALYSIS)) throw new Exception("Mode unknown: " + (Object)((Object)this.mode));
        String key = record.getChromosome() + "_" + record.getPosition() + "_" + record.getRef() + "_" + record.getAlt(altIndex);
        if (this.caddScores.containsKey(key)) {
            record.setCaddPhredScore(altIndex, this.caddScores.get(key));
            return record.getCaddPhredScore(altIndex);
        } else {
            String trimmedRefAlt = FixVcfAlleleNotation.backTrimRefAlt(record.getRef(), record.getAlt(altIndex), "_");
            key = record.getChromosome() + "_" + record.getPosition() + "_" + trimmedRefAlt;
            if (this.caddScores.containsKey(key)) {
                return this.caddScores.get(key);
            }
            LOG.warn("[HandleMissingCaddScores] CADD score missing for {} {} {} {} ! (even when using trimmed key '{}')", record.getChromosome(), record.getPosition(), record.getRef(), record.getAlt(altIndex), key);
            return null;
        }
    }

    public static enum Mode {
        ANALYSIS,
        CREATEFILEFORCADD;

    }
}

