/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.makervcf.util;

import java.io.File;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.molgenis.calibratecadd.support.GavinUtils;
import org.molgenis.data.annotation.makervcf.structs.GavinRecord;
import org.molgenis.vcf.VcfReader;
import org.molgenis.vcf.VcfRecord;

public class GetAllGeneNamesFromVCF {
    public static void main(String[] args) throws Exception {
        File vcfFile = new File("/Users/joeri/Desktop/1000G_diag_FDR/exomePlus/ALL.chr1to22plusXYMT.phase3_20130502.variantsOnly.snpEffNoIntergenic.exac.gonl.cadd.vcf.gz");
        try (PrintWriter pw = new PrintWriter(new File("/Users/joeri/Desktop/1000G_diag_FDR/exomePlus/allGenes.txt"));){
            try (VcfReader vcf = GavinUtils.getVcfReader(vcfFile);){
                Iterator<VcfRecord> vcfIterator = vcf.iterator();
                HashSet<String> genes = new HashSet<String>();
                int i = 0;
                while (vcfIterator.hasNext()) {
                    GavinRecord record = new GavinRecord(vcfIterator.next());
                    ++i;
                    Set<String> genesForVariant = record.getGenes();
                    if (genesForVariant != null) {
                        genes.addAll(record.getGenes());
                    }
                    if (i % 10000 != 0) continue;
                    System.out.println("Seen " + i + " variants, found " + genes.size() + " unique genes so far..");
                }
                System.out.println("Writing results..");
                for (String gene : genes) {
                    pw.println(gene);
                }
                pw.flush();
                pw.close();
            }
            System.out.println("Done");
        }
    }
}

