/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.makervcf.structs;

import com.google.common.base.Splitter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.molgenis.data.annotation.makervcf.positionalstream.MatchVariantsToGenotypeAndInheritance;
import org.molgenis.data.annotation.makervcf.structs.AnnotatedVcfParseException;
import org.molgenis.data.annotation.makervcf.structs.RVCFUtils;
import org.molgenis.vcf.VcfInfo;

public class RVCF {
    public static final String RLV_PRESENT = "RLV_PRESENT";
    public static final String RLV_ALLELE = "RLV_ALLELE";
    public static final String RLV_ALLELEFREQ = "RLV_ALLELEFREQ";
    public static final String RLV_GENE = "RLV_GENE";
    public static final String RLV_FDR = "RLV_FDR";
    public static final String RLV_TRANSCRIPT = "RLV_TRANSCRIPT";
    public static final String RLV_PHENOTYPE = "RLV_PHENOTYPE";
    public static final String RLV_PHENOTYPEINHERITANCE = "RLV_PHENOTYPEINHERITANCE";
    public static final String RLV_PHENOTYPEONSET = "RLV_PHENOTYPEONSET";
    public static final String RLV_PHENOTYPEDETAILS = "RLV_PHENOTYPEDETAILS";
    public static final String RLV_PHENOTYPEGROUP = "RLV_PHENOTYPEGROUP";
    public static final String RLV_SAMPLESTATUS = "RLV_SAMPLESTATUS";
    public static final String RLV_SAMPLEPHENOTYPE = "RLV_SAMPLEPHENOTYPE";
    public static final String RLV_SAMPLEGENOTYPE = "RLV_SAMPLEGENOTYPE";
    public static final String RLV_SAMPLEGROUP = "RLV_SAMPLEGROUP";
    public static final String RLV_VARIANTSIGNIFICANCE = "RLV_VARIANTSIGNIFICANCE";
    public static final String RLV_VARIANTSIGNIFICANCESOURCE = "RLV_VARIANTSIGNIFICANCESOURCE";
    public static final String RLV_VARIANTSIGNIFICANCEJUSTIFICATION = "RLV_VARIANTSIGNIFICANCEJUSTIFICATION";
    public static final String RLV_VARIANTMULTIGENIC = "RLV_VARIANTMULTIGENIC";
    public static final String RLV_VARIANTGROUP = "RLV_VARIANTGROUP";
    public static final String FIELD_NAME = "RLV";
    public static final int NR_OF_FIELDS = 19;
    private static final String RVCF_FIELDSEP = "|";
    public static final String DESCRIPTION = "Allele | AlleleFreq | Gene | FDR | Transcript | Phenotype | PhenotypeInheritance | PhenotypeOnset | PhenotypeDetails | PhenotypeGroup | SampleStatus | SamplePhenotype | SampleGenotype | SampleGroup | VariantSignificance | VariantSignificanceSource | VariantSignificanceJustification | VariantMultiGenic | VariantGroup";
    String allele;
    String alleleFreq;
    String gene;
    String FDR;
    String transcript;
    String phenotype;
    String phenotypeInheritance;
    String phenotypeOnset;
    String phenotypeDetails;
    String phenotypeGroup;
    Map<String, MatchVariantsToGenotypeAndInheritance.Status> sampleStatus;
    Map<String, String> samplePhenotype;
    Map<String, String> sampleGenotype;
    Map<String, String> sampleGroup;
    String variantSignificance;
    String variantSignificanceSource;
    String variantSignificanceJustification;
    String variantMultiGenic;
    String variantGroup;

    public static List<RVCF> fromVcfInfo(VcfInfo vcfInfo) {
        Object obj = vcfInfo.getVal();
        if (!(obj instanceof List)) {
            throw new AnnotatedVcfParseException(String.format("Error parsing RLV info field value '%s'. Value is not a list of strings.", vcfInfo.getValRaw()));
        }
        List rlvValue = (List)obj;
        return rlvValue.stream().map(RVCF::fromString).collect(Collectors.toList());
    }

    public RVCF() {
    }

    public RVCF(String allele, String alleleFreq, String gene, String FDR2, String transcript, String phenotype, String phenotypeInheritance, String phenotypeOnset, String phenotypeDetails, String phenotypeGroup, Map<String, MatchVariantsToGenotypeAndInheritance.Status> sampleStatus, Map<String, String> samplePhenotype, Map<String, String> sampleGenotype, Map<String, String> sampleGroup, String variantSignificance, String variantSignificanceSource, String variantSignificanceJustification, String variantMultiGenic, String variantGroup) {
        this.allele = allele;
        this.alleleFreq = alleleFreq;
        this.gene = gene;
        this.FDR = FDR2;
        this.transcript = transcript;
        this.phenotype = phenotype;
        this.phenotypeInheritance = phenotypeInheritance;
        this.phenotypeOnset = phenotypeOnset;
        this.phenotypeDetails = phenotypeDetails;
        this.phenotypeGroup = phenotypeGroup;
        this.sampleStatus = sampleStatus;
        this.samplePhenotype = samplePhenotype;
        this.sampleGenotype = sampleGenotype;
        this.sampleGroup = sampleGroup;
        this.variantSignificance = variantSignificance;
        this.variantSignificanceSource = variantSignificanceSource;
        this.variantSignificanceJustification = variantSignificanceJustification;
        this.variantMultiGenic = variantMultiGenic;
        this.variantGroup = variantGroup;
    }

    public static RVCF fromString(String rvcfEntry) {
        String[] split = rvcfEntry.split("\\|", -1);
        RVCF rvcfInstance = new RVCF();
        if (split.length != 19) {
            System.out.println("RVCF parsing failed for " + rvcfEntry);
            throw new RuntimeException("Splitting RVCF entry on '|' did not yield 19 fields, invalid format? tried to split: " + rvcfEntry + " but had " + split.length + " fields");
        }
        rvcfInstance.setAllele(split[0]);
        rvcfInstance.setAlleleFreq(split[1]);
        rvcfInstance.setGene(split[2]);
        rvcfInstance.setFDR(split[3]);
        rvcfInstance.setTranscript(split[4]);
        rvcfInstance.setPhenotype(split[5]);
        rvcfInstance.setPhenotypeInheritance(split[6]);
        rvcfInstance.setPhenotypeOnset(split[7]);
        rvcfInstance.setPhenotypeDetails(split[8]);
        rvcfInstance.setPhenotypeGroup(split[9]);
        rvcfInstance.setSampleStatusString(split[10].isEmpty() ? new HashMap<String, String>() : Splitter.on("/").withKeyValueSeparator(":").split(split[10]));
        rvcfInstance.setSampleGenotype(split[12].isEmpty() ? new HashMap<String, String>() : Splitter.on("/").withKeyValueSeparator(":").split(split[12]));
        rvcfInstance.setVariantSignificance(split[14]);
        rvcfInstance.setVariantSignificanceSource(split[15]);
        rvcfInstance.setVariantSignificanceJustification(split[16]);
        rvcfInstance.setVariantMultiGenic(split[17]);
        rvcfInstance.setVariantGroup(split[18]);
        return rvcfInstance;
    }

    public String getFDR() {
        return this.FDR != null ? this.FDR : "";
    }

    public void setFDR(String FDR2) {
        this.FDR = FDR2;
    }

    public String getAlleleFreq() {
        return this.alleleFreq != null ? this.alleleFreq : "";
    }

    public void setAlleleFreq(String alleleFreq) {
        this.alleleFreq = alleleFreq;
    }

    public String getPhenotypeOnset() {
        return this.phenotypeOnset != null ? this.phenotypeOnset : "";
    }

    public void setPhenotypeOnset(String phenotypeOnset) {
        this.phenotypeOnset = phenotypeOnset;
    }

    public String getAllele() {
        return this.allele != null ? this.allele : "";
    }

    public void setAllele(String allele) {
        this.allele = allele;
    }

    public String getGene() {
        return this.gene != null ? this.gene : "";
    }

    public void setGene(String gene) {
        this.gene = gene;
    }

    public String getTranscript() {
        return this.transcript;
    }

    public void setTranscript(String transcript) {
        this.transcript = transcript;
    }

    public String getPhenotype() {
        return this.phenotype != null ? this.phenotype : "";
    }

    public void setPhenotype(String phenotype) {
        this.phenotype = phenotype;
    }

    public String getPhenotypeInheritance() {
        return this.phenotypeInheritance != null ? this.phenotypeInheritance : "";
    }

    public void setPhenotypeInheritance(String phenotypeInheritance) {
        this.phenotypeInheritance = phenotypeInheritance;
    }

    public String getPhenotypeDetails() {
        return this.phenotypeDetails != null ? this.phenotypeDetails : "";
    }

    public void setPhenotypeDetails(String phenotypeDetails) {
        this.phenotypeDetails = phenotypeDetails;
    }

    public String getPhenotypeGroup() {
        return this.phenotypeGroup != null ? this.phenotypeGroup : "";
    }

    public void setPhenotypeGroup(String phenotypeGroup) {
        this.phenotypeGroup = phenotypeGroup;
    }

    public Map<String, String> getSampleGenotype() {
        return this.sampleGenotype != null ? this.sampleGenotype : new HashMap<String, String>();
    }

    public void setSampleGenotype(Map<String, String> sampleGenotype) {
        HashMap<String, String> sampleGenotypeUnEsc = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : sampleGenotype.entrySet()) {
            sampleGenotypeUnEsc.put(entry.getKey(), RVCFUtils.unEscapeGenotype(entry.getValue()));
        }
        this.sampleGenotype = sampleGenotypeUnEsc;
    }

    public Map<String, MatchVariantsToGenotypeAndInheritance.Status> getSampleStatus() {
        return this.sampleStatus != null ? this.sampleStatus : new HashMap<String, MatchVariantsToGenotypeAndInheritance.Status>();
    }

    public void setSampleStatusString(Map<String, String> sampleStatus) {
        HashMap<String, MatchVariantsToGenotypeAndInheritance.Status> res = new HashMap<String, MatchVariantsToGenotypeAndInheritance.Status>();
        for (Map.Entry<String, String> sampleStatusEntry : sampleStatus.entrySet()) {
            res.put(sampleStatusEntry.getKey(), MatchVariantsToGenotypeAndInheritance.Status.valueOf(sampleStatusEntry.getValue()));
        }
        this.sampleStatus = res;
    }

    public void setSampleStatus(Map<String, MatchVariantsToGenotypeAndInheritance.Status> sampleStatus) {
        this.sampleStatus = sampleStatus;
    }

    public Map<String, String> getSamplePhenotype() {
        return this.samplePhenotype != null ? this.samplePhenotype : new HashMap<String, String>();
    }

    public void setSamplePhenotype(Map<String, String> samplePhenotype) {
        this.samplePhenotype = samplePhenotype;
    }

    public Map<String, String> getSampleGroup() {
        return this.sampleGroup != null ? this.sampleGroup : new HashMap<String, String>();
    }

    public void setSampleGroup(Map<String, String> sampleGroup) {
        this.sampleGroup = sampleGroup;
    }

    public String getVariantSignificance() {
        return this.variantSignificance != null ? this.variantSignificance : "";
    }

    public void setVariantSignificance(String variantSignificance) {
        this.variantSignificance = variantSignificance;
    }

    public String getVariantSignificanceSource() {
        return this.variantSignificanceSource != null ? this.variantSignificanceSource : "";
    }

    public void setVariantSignificanceSource(String variantSignificanceSource) {
        this.variantSignificanceSource = variantSignificanceSource;
    }

    public String getVariantSignificanceJustification() {
        return this.variantSignificanceJustification != null ? this.variantSignificanceJustification : "";
    }

    public void setVariantSignificanceJustification(String variantSignificanceJustification) {
        this.variantSignificanceJustification = variantSignificanceJustification;
    }

    public String getVariantMultiGenic() {
        return this.variantMultiGenic != null ? this.variantMultiGenic : "";
    }

    public void setVariantMultiGenic(String variantMultiGenic) {
        this.variantMultiGenic = variantMultiGenic;
    }

    public String getVariantGroup() {
        return this.variantGroup != null ? this.variantGroup : "";
    }

    public void setVariantGroup(String variantGroup) {
        this.variantGroup = variantGroup;
    }

    public String toString() {
        return "RVCF{allele='" + this.allele + '\'' + ", alleleFreq='" + this.alleleFreq + '\'' + ", gene='" + this.gene + '\'' + ", FDR='" + this.FDR + '\'' + ", transcript='" + this.transcript + '\'' + ", phenotype='" + this.phenotype + '\'' + ", phenotypeInheritance='" + this.phenotypeInheritance + '\'' + ", phenotypeOnset='" + this.phenotypeOnset + '\'' + ", phenotypeDetails='" + this.phenotypeDetails + '\'' + ", phenotypeGroup='" + this.phenotypeGroup + '\'' + ", sampleStatus=" + this.sampleStatus + ", samplePhenotype=" + this.samplePhenotype + ", sampleGenotype=" + this.sampleGenotype + ", sampleGroup=" + this.sampleGroup + ", variantSignificance='" + this.variantSignificance + '\'' + ", variantSignificanceSource='" + this.variantSignificanceSource + '\'' + ", variantSignificanceJustification='" + this.variantSignificanceJustification + '\'' + ", variantMultiGenic='" + this.variantMultiGenic + '\'' + ", variantGroup='" + this.variantGroup + '\'' + '}';
    }
}

