/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.makervcf.structs;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.data.annotation.core.entity.impl.snpeff.Impact;
import org.molgenis.data.annotation.makervcf.structs.AnnotatedVcfRecord;
import org.molgenis.data.annotation.makervcf.structs.Relevance;
import org.molgenis.data.vcf.datastructures.Sample;
import org.molgenis.vcf.VcfRecord;
import org.molgenis.vcf.VcfRecordUtils;

public class GavinRecord {
    private AnnotatedVcfRecord annotatedVcfRecord;
    private List<Relevance> relevances;
    private Set<String> genes;
    private Double[] caddPhredScores;

    public GavinRecord(VcfRecord record) {
        this(record, Collections.emptyList());
    }

    public GavinRecord(VcfRecord record, List<Relevance> relevances) {
        this.annotatedVcfRecord = new AnnotatedVcfRecord(record);
        this.relevances = Objects.requireNonNull(relevances);
        this.genes = this.annotatedVcfRecord.getGenesFromAnn();
        this.caddPhredScores = this.annotatedVcfRecord.getCaddPhredScores();
    }

    public AnnotatedVcfRecord getAnnotatedVcfRecord() {
        return this.annotatedVcfRecord;
    }

    public void setRelevances(List<Relevance> relevances) {
        this.relevances = Objects.requireNonNull(relevances);
    }

    public boolean isRelevant() {
        return !this.relevances.isEmpty();
    }

    public Double getCaddPhredScore(int i) {
        return this.caddPhredScores[i];
    }

    public Double[] getCaddPhredScores() {
        return this.caddPhredScores;
    }

    public void setCaddPhredScore(int i, Double phredScore) {
        this.caddPhredScores[i] = phredScore;
    }

    public Set<String> getGenes() {
        return this.genes;
    }

    public void setGenes(String gene) {
        this.genes = Collections.singleton(gene);
    }

    public void setGenes(Set<String> genes) {
        this.genes = genes;
    }

    public List<Relevance> getRelevance() {
        return this.relevances;
    }

    public String toStringShort() {
        return this.annotatedVcfRecord.getChromosome() + " " + this.annotatedVcfRecord.getPosition() + " " + VcfRecordUtils.getRef(this.annotatedVcfRecord) + " " + VcfRecordUtils.getAltString(this.annotatedVcfRecord);
    }

    public Stream<Sample> getSamples() {
        return VcfRecordUtils.toSamples(this.annotatedVcfRecord);
    }

    public int getAltAlleleIndex(String alt) {
        return VcfRecordUtils.getAltAlleleIndex(this.annotatedVcfRecord, alt);
    }

    public String getChromosome() {
        return this.annotatedVcfRecord.getChromosome();
    }

    public int getPosition() {
        return this.annotatedVcfRecord.getPosition();
    }

    public List<String> getIdentifiers() {
        return this.annotatedVcfRecord.getIdentifiers();
    }

    public Optional<Double> getQuality() {
        String quality = this.annotatedVcfRecord.getQuality();
        return quality != null ? Optional.of(Double.valueOf(quality)) : Optional.empty();
    }

    public List<String> getFilterStatus() {
        String filterStatus = this.annotatedVcfRecord.getFilterStatus();
        if (filterStatus == null) {
            return Collections.emptyList();
        }
        if (filterStatus.equals("PASS")) {
            return Collections.singletonList("PASS");
        }
        return Arrays.asList(StringUtils.split(filterStatus, ';'));
    }

    public String getRef() {
        return VcfRecordUtils.getRef(this.annotatedVcfRecord);
    }

    public String getAlt() {
        return VcfRecordUtils.getAlt(this.annotatedVcfRecord);
    }

    public String getAlt(int altIndex) {
        return VcfRecordUtils.getAlt(this.annotatedVcfRecord, altIndex);
    }

    public String getChrPosRefAlt() {
        return VcfRecordUtils.getChrPosRefAlt(this.annotatedVcfRecord);
    }

    public int getAltIndex(String allele) throws Exception {
        return VcfRecordUtils.getAltIndex(this.annotatedVcfRecord, allele);
    }

    public String[] getAlts() {
        return VcfRecordUtils.getAlts(this.annotatedVcfRecord);
    }

    public double getExAcAlleleFrequencies(int i) {
        return this.annotatedVcfRecord.getExAcAlleleFrequencies(i);
    }

    public double getGoNlAlleleFrequencies(int i) {
        return this.annotatedVcfRecord.getGoNlAlleleFrequencies(i);
    }

    public Optional<Impact> getImpact(int i, String gene) {
        return this.annotatedVcfRecord.getImpact(i, gene);
    }

    public Optional<String> getTranscript(int i, String gene) {
        return this.annotatedVcfRecord.getTranscript(i, gene);
    }

    public String getId() {
        return VcfRecordUtils.getId(this.annotatedVcfRecord);
    }
}

