/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.makervcf.structs;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.molgenis.data.annotation.core.entity.impl.snpeff.Impact;
import org.molgenis.data.annotation.makervcf.structs.RVCF;
import org.molgenis.vcf.VcfInfo;
import org.molgenis.vcf.VcfRecord;
import org.molgenis.vcf.VcfRecordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotatedVcfRecord
extends VcfRecord {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotatedVcfRecord.class);
    private static final String EXAC_AF = "EXAC_AF";
    private static final String GO_NL_AF = "GoNL_AF";
    private static final String CLSF = "CLSF";
    private static final String ANN = "ANN";
    private static final String RLV = "RLV";
    private static final String REPORTEDPATHOGENIC = "REPORTEDPATHOGENIC";
    public static final String CADD_SCALED = "CADD_SCALED";

    public AnnotatedVcfRecord(VcfRecord record) {
        super(record.getVcfMeta(), record.getTokens());
    }

    double getExAcAlleleFrequencies(int i) {
        Double[] alleleFrequencies = VcfRecordUtils.getAltAlleleOrderedDoubleField(this, EXAC_AF);
        return alleleFrequencies[i] != null ? alleleFrequencies[i] : 0.0;
    }

    double getGoNlAlleleFrequencies(int i) {
        Double[] alleleFrequencies = VcfRecordUtils.getAltAlleleOrderedDoubleField(this, GO_NL_AF);
        return alleleFrequencies[i] != null ? alleleFrequencies[i] : 0.0;
    }

    public Optional<String> getClsf() {
        Optional<VcfInfo> optionalVcfInfo = VcfRecordUtils.getInformation(CLSF, this);
        return optionalVcfInfo.map(vcfInfo -> (String)vcfInfo.getVal());
    }

    Set<String> getGenesFromAnn() {
        Optional<VcfInfo> optionalVcfInfo = VcfRecordUtils.getInformation(ANN, this);
        return optionalVcfInfo.map(vcfInfo -> {
            String[] annSplit;
            String ann = vcfInfo.getValRaw();
            HashSet<String> genes = new HashSet<String>();
            for (String oneAnn : annSplit = ann.split(",", -1)) {
                String[] fields = oneAnn.split("\\|", -1);
                String gene = fields[3];
                genes.add(gene);
            }
            return genes;
        }).orElse(Collections.emptySet());
    }

    Optional<Impact> getImpact(int i, String gene) {
        String allele = VcfRecordUtils.getAltsAsStringArray(this)[i];
        Optional<VcfInfo> optionalVcfInfo = VcfRecordUtils.getInformation(ANN, this);
        return optionalVcfInfo.map(vcfInfo -> AnnotatedVcfRecord.getImpact(vcfInfo.getValRaw(), gene, allele));
    }

    Optional<String> getTranscript(int i, String gene) {
        String allele = VcfRecordUtils.getAltsAsStringArray(this)[i];
        Optional<VcfInfo> optionalVcfInfo = VcfRecordUtils.getInformation(ANN, this);
        return optionalVcfInfo.map(vcfInfo -> AnnotatedVcfRecord.getTranscript(vcfInfo.getValRaw(), gene, allele));
    }

    public List<RVCF> getRvcf() {
        Optional<VcfInfo> optionalVcfInfo = VcfRecordUtils.getInformation(RLV, this);
        return optionalVcfInfo.map(RVCF::fromVcfInfo).orElse(Collections.emptyList());
    }

    Double[] getCaddPhredScores() {
        return VcfRecordUtils.getAltAlleleOrderedDoubleField(this, CADD_SCALED);
    }

    public Optional<String> getReportedPathogenic() {
        Optional<VcfInfo> optionalVcfInfo = VcfRecordUtils.getInformation(REPORTEDPATHOGENIC, this);
        return optionalVcfInfo.map(vcfInfo -> (String)vcfInfo.getVal());
    }

    private static Impact getImpact(String ann, String gene, String allele) {
        String findAnn = AnnotatedVcfRecord.getAnn(ann, gene, allele);
        if (findAnn == null) {
            LOG.warn("failed to get impact for gene '{}', allele '{}' in {}", gene, allele, ann);
            return null;
        }
        String[] fields = findAnn.split("\\|", -1);
        String impact = fields[2];
        return Impact.valueOf(impact);
    }

    private static String getTranscript(String ann, String gene, String allele) {
        String findAnn = AnnotatedVcfRecord.getAnn(ann, gene, allele);
        if (findAnn == null) {
            LOG.warn("failed to get impact for gene '{}', allele '{}' in {}", gene, allele, ann);
            return null;
        }
        String[] fields = findAnn.split("\\|", -1);
        return fields[6];
    }

    private static String getAnn(String ann, String gene, String allele) {
        String[] annSplit;
        for (String oneAnn : annSplit = ann.split(",", -1)) {
            String alleleFromAnn;
            String[] fields = oneAnn.split("\\|", -1);
            String geneFromAnn = fields[3];
            if (!gene.equals(geneFromAnn) || !allele.equals(alleleFromAnn = fields[0])) continue;
            return oneAnn;
        }
        LOG.warn("annotation could not be found for {}, allele={}, ann={}", gene, allele, ann);
        return null;
    }
}

