/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.makervcf.genestream.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.molgenis.data.annotation.makervcf.genestream.core.GeneStream;
import org.molgenis.data.annotation.makervcf.positionalstream.MatchVariantsToGenotypeAndInheritance;
import org.molgenis.data.annotation.makervcf.structs.GavinRecord;
import org.molgenis.data.annotation.makervcf.structs.Relevance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhasingCompoundCheck
extends GeneStream {
    private static final Logger LOG = LoggerFactory.getLogger(PhasingCompoundCheck.class);

    public PhasingCompoundCheck(Iterator<GavinRecord> relevantVariants) {
        super(relevantVariants);
    }

    @Override
    public void perGene(String gene, List<GavinRecord> variantsPerGene) throws Exception {
        LOG.debug("[PhasingCompoundCheck] Encountered gene: {}", (Object)gene);
        HashSet<String> leftHaploSamples = new HashSet<String>();
        HashSet<String> rightHaploSamples = new HashSet<String>();
        HashSet<String> samplesWithUnphasedVariants = new HashSet<String>();
        for (GavinRecord gavinRecord : variantsPerGene) {
            if (!gavinRecord.isRelevant()) continue;
            for (Relevance rlv : gavinRecord.getRelevance()) {
                if (!rlv.getGene().equals(gene)) continue;
                char affectedIndex = Character.forDigit(gavinRecord.getAltIndex(rlv.getAllele()), 10);
                for (String sample : rlv.getSampleStatus().keySet()) {
                    if (samplesWithUnphasedVariants.contains(sample) || !MatchVariantsToGenotypeAndInheritance.Status.isCompound(rlv.getSampleStatus().get(sample))) continue;
                    String geno = rlv.getSampleGenotypes().get(sample);
                    LOG.debug("[PhasingCompoundCheck] Sample {} has a {} genotype {}", new Object[]{sample, rlv.getSampleStatus().get(sample), geno});
                    if (geno.length() != 3) {
                        throw new Exception("genotype length != 3");
                    }
                    if (geno.charAt(1) == '/') {
                        samplesWithUnphasedVariants.add(sample);
                        LOG.debug("[PhasingCompoundCheck] Sample unphased, excluded");
                        continue;
                    }
                    if (geno.charAt(0) == affectedIndex && geno.charAt(1) == '|' && geno.charAt(2) != affectedIndex) {
                        leftHaploSamples.add(sample);
                        continue;
                    }
                    if (geno.charAt(0) != affectedIndex && geno.charAt(1) == '|' && geno.charAt(2) == affectedIndex) {
                        rightHaploSamples.add(sample);
                        continue;
                    }
                    throw new Exception("No match to either unphased or phased genotype, whats going on? sample " + sample + " has a " + (Object)((Object)rlv.getSampleStatus().get(sample)) + " genotype " + geno);
                }
            }
        }
        LOG.debug("[PhasingCompoundCheck] 'Left-hand' haplotype samples: {}", (Object)leftHaploSamples);
        LOG.debug("[PhasingCompoundCheck] 'Right-hand' haplotype samples: {}", (Object)rightHaploSamples);
        HashSet<String> union = new HashSet<String>(leftHaploSamples);
        union.addAll(rightHaploSamples);
        for (String inA : leftHaploSamples) {
            if (!rightHaploSamples.contains(inA)) continue;
            union.remove(inA);
        }
        LOG.debug("[PhasingCompoundCheck] False compounds with only left-hand or right-hand haplotypes: {}", (Object)union);
        for (GavinRecord gavinRecord : variantsPerGene) {
            if (!gavinRecord.isRelevant()) continue;
            for (Relevance rlv : gavinRecord.getRelevance()) {
                if (!rlv.getGene().equals(gene)) continue;
                for (String sample : rlv.getSampleStatus().keySet()) {
                    if (!union.contains(sample) || samplesWithUnphasedVariants.contains(sample) || !MatchVariantsToGenotypeAndInheritance.Status.isCompound(rlv.getSampleStatus().get(sample))) continue;
                    LOG.debug("[PhasingCompoundCheck] Going to update sample {} from {} to {}", new Object[]{sample, rlv.getSampleStatus().get(sample), MatchVariantsToGenotypeAndInheritance.Status.HETEROZYGOUS_MULTIHIT});
                    rlv.getSampleStatus().put(sample, MatchVariantsToGenotypeAndInheritance.Status.HETEROZYGOUS_MULTIHIT);
                }
            }
        }
    }
}

