/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.makervcf.genestream.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.map.MultiKeyMap;
import org.molgenis.data.annotation.makervcf.genestream.core.GeneStream;
import org.molgenis.data.annotation.makervcf.positionalstream.MatchVariantsToGenotypeAndInheritance;
import org.molgenis.data.annotation.makervcf.structs.GavinRecord;
import org.molgenis.data.annotation.makervcf.structs.Relevance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssignCompoundHet
extends GeneStream {
    private static final Logger LOG = LoggerFactory.getLogger(AssignCompoundHet.class);

    public AssignCompoundHet(Iterator<GavinRecord> relevantVariants) {
        super(relevantVariants);
    }

    @Override
    public void perGene(String gene, List<GavinRecord> variantsPerGene) {
        MultiKeyMap geneAlleleToSeenSamples = new MultiKeyMap();
        MultiKeyMap geneAlleleToMarkedSamples = new MultiKeyMap();
        for (GavinRecord gavinRecord : variantsPerGene) {
            if (!gavinRecord.isRelevant()) continue;
            for (Relevance rlv : gavinRecord.getRelevance()) {
                if (!rlv.getGene().equals(gene)) continue;
                for (String sample : rlv.getSampleStatus().keySet()) {
                    if (rlv.getSampleStatus().get(sample) != MatchVariantsToGenotypeAndInheritance.Status.HETEROZYGOUS && rlv.getSampleStatus().get(sample) != MatchVariantsToGenotypeAndInheritance.Status.CARRIER) continue;
                    LOG.debug("[AssignCompoundHet] Gene {} , sample: {}, Status: {}", new Object[]{rlv.getGene(), sample, rlv.getSampleStatus().get(sample)});
                    if (geneAlleleToSeenSamples.get(rlv.getGene(), rlv.getAllele()) != null && ((Set)geneAlleleToSeenSamples.get(rlv.getGene(), rlv.getAllele())).contains(sample)) {
                        LOG.debug("[AssignCompoundHet] Marking as potential compound heterozygous: {}", (Object)sample);
                        if (geneAlleleToMarkedSamples.containsKey(rlv.getGene(), rlv.getAllele())) {
                            ((Set)geneAlleleToMarkedSamples.get(rlv.getGene(), rlv.getAllele())).add(sample);
                        } else {
                            HashSet<String> markedSamples = new HashSet<String>();
                            markedSamples.add(sample);
                            geneAlleleToMarkedSamples.put(rlv.getGene(), rlv.getAllele(), markedSamples);
                        }
                    }
                    if (geneAlleleToSeenSamples.containsKey(rlv.getGene(), rlv.getAllele())) {
                        ((Set)geneAlleleToSeenSamples.get(rlv.getGene(), rlv.getAllele())).add(sample);
                        continue;
                    }
                    HashSet<String> seenSamples = new HashSet<String>();
                    seenSamples.add(sample);
                    geneAlleleToSeenSamples.put(rlv.getGene(), rlv.getAllele(), seenSamples);
                }
            }
        }
        for (GavinRecord rv : variantsPerGene) {
            for (Relevance rlv : rv.getRelevance()) {
                if (!rlv.getGene().equals(gene) || geneAlleleToMarkedSamples.get(rlv.getGene(), rlv.getAllele()) == null) continue;
                for (String sample : (Set)geneAlleleToMarkedSamples.get(rlv.getGene(), rlv.getAllele())) {
                    if (!rlv.getSampleStatus().containsKey(sample)) continue;
                    if (rlv.getSampleStatus().get(sample) == MatchVariantsToGenotypeAndInheritance.Status.HETEROZYGOUS) {
                        LOG.debug("[AssignCompoundHet] Reassigning {} from {} to {}", new Object[]{sample, MatchVariantsToGenotypeAndInheritance.Status.HETEROZYGOUS, MatchVariantsToGenotypeAndInheritance.Status.HOMOZYGOUS_COMPOUNDHET});
                        rlv.getSampleStatus().put(sample, MatchVariantsToGenotypeAndInheritance.Status.HOMOZYGOUS_COMPOUNDHET);
                        continue;
                    }
                    if (rlv.getSampleStatus().get(sample) != MatchVariantsToGenotypeAndInheritance.Status.CARRIER) continue;
                    LOG.debug("[AssignCompoundHet] Reassigning {} from {} to {}", new Object[]{sample, MatchVariantsToGenotypeAndInheritance.Status.CARRIER, MatchVariantsToGenotypeAndInheritance.Status.AFFECTED_COMPOUNDHET});
                    rlv.getSampleStatus().put(sample, MatchVariantsToGenotypeAndInheritance.Status.AFFECTED_COMPOUNDHET);
                }
            }
        }
    }
}

