/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.makervcf.genestream.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.molgenis.data.annotation.makervcf.structs.GavinRecord;
import org.molgenis.data.annotation.makervcf.structs.Relevance;
import org.molgenis.data.annotation.makervcf.structs.RelevanceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GeneStream {
    private static final Logger LOG = LoggerFactory.getLogger(GeneStream.class);
    private Iterator<GavinRecord> gavinRecordIterator;
    private boolean isFilterNonRelevant;

    public GeneStream(Iterator<GavinRecord> gavinRecordIterator) {
        this.gavinRecordIterator = gavinRecordIterator;
    }

    public Iterator<GavinRecord> go() {
        return new Iterator<GavinRecord>(){
            GavinRecord nextResult;
            Set<String> previousGenes;
            Set<String> currentGenes;
            HashMap<String, List<GavinRecord>> variantBufferPerGene = new HashMap();
            List<GavinRecord> variantBuffer = new ArrayList<GavinRecord>();
            Iterator<GavinRecord> resultBatch;

            @Override
            public boolean hasNext() {
                if (this.resultBatch != null && this.resultBatch.hasNext()) {
                    LOG.debug("[GeneStream] Returning subsequent result of gene stream batch");
                    this.nextResult = this.resultBatch.next();
                    return true;
                }
                while (GeneStream.this.gavinRecordIterator.hasNext()) {
                    GavinRecord gavinRecord = (GavinRecord)GeneStream.this.gavinRecordIterator.next();
                    if (gavinRecord.isRelevant()) {
                        if (this.resultBatch != null) {
                            LOG.debug("[GeneStream] Cleanup by setting result batch to null");
                            this.resultBatch = null;
                        }
                        this.currentGenes = RelevanceUtils.getRelevantGenes(gavinRecord.getRelevance());
                        LOG.debug("[GeneStream] Entering while, looking at a variant in gene " + this.currentGenes);
                        if (this.previousGenes != null && Collections.disjoint(this.previousGenes, this.currentGenes)) {
                            LOG.debug("[GeneStream] Executing the abstract perGene() function on " + this.previousGenes);
                            for (String gene : this.variantBufferPerGene.keySet()) {
                                LOG.debug("[GeneStream] Processing gene " + gene + " having " + this.variantBufferPerGene.get(gene).size() + " variants");
                                try {
                                    GeneStream.this.perGene(gene, this.variantBufferPerGene.get(gene));
                                }
                                catch (Exception e) {
                                    throw new RuntimeException(e);
                                }
                            }
                            this.resultBatch = new ArrayList<GavinRecord>(this.variantBuffer).iterator();
                            this.variantBuffer = new ArrayList<GavinRecord>();
                            this.variantBufferPerGene = new HashMap();
                        }
                        for (Relevance rlv : gavinRecord.getRelevance()) {
                            String gene = rlv.getGene();
                            if (this.variantBufferPerGene.containsKey(gene)) {
                                this.variantBufferPerGene.get(gene).add(gavinRecord);
                                continue;
                            }
                            ArrayList<GavinRecord> variants = new ArrayList<GavinRecord>();
                            variants.add(gavinRecord);
                            this.variantBufferPerGene.put(gene, variants);
                        }
                        this.variantBuffer.add(gavinRecord);
                        this.previousGenes = this.currentGenes;
                        if (this.resultBatch == null || !this.resultBatch.hasNext()) continue;
                        LOG.debug("[GeneStream] Returning first result of gene stream batch");
                        this.nextResult = this.resultBatch.next();
                        return true;
                    }
                    if (GeneStream.this.isFilterNonRelevant) continue;
                    this.nextResult = gavinRecord;
                    return true;
                }
                if (this.variantBuffer.size() > 0) {
                    LOG.debug("[GeneStream] Buffer has " + this.variantBuffer.size() + " variants left in " + this.variantBufferPerGene.keySet().toString());
                    for (String gene : this.variantBufferPerGene.keySet()) {
                        try {
                            GeneStream.this.perGene(gene, this.variantBufferPerGene.get(gene));
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                    this.resultBatch = new ArrayList<GavinRecord>(this.variantBuffer).iterator();
                    this.variantBuffer = new ArrayList<GavinRecord>();
                    this.variantBufferPerGene = new HashMap();
                    if (this.resultBatch.hasNext()) {
                        LOG.debug("[GeneStream] Returning first of remaining variants");
                        this.nextResult = this.resultBatch.next();
                        return true;
                    }
                }
                return false;
            }

            @Override
            public GavinRecord next() {
                return this.nextResult;
            }
        };
    }

    public abstract void perGene(String var1, List<GavinRecord> var2) throws Exception;
}

