/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.makervcf.genestream.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.molgenis.data.annotation.makervcf.structs.GavinRecord;
import org.molgenis.data.annotation.makervcf.structs.Relevance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertToGeneStream {
    private static final Logger LOG = LoggerFactory.getLogger(ConvertToGeneStream.class);
    private Iterator<GavinRecord> gavinRecordIterator;
    private List<Integer> positionalOrder;

    public ConvertToGeneStream(Iterator<GavinRecord> gavinRecordIterator) {
        this.gavinRecordIterator = gavinRecordIterator;
        this.positionalOrder = new ArrayList<Integer>();
    }

    public List<Integer> getPositionalOrder() {
        return this.positionalOrder;
    }

    public Iterator<GavinRecord> go() {
        return new Iterator<GavinRecord>(){
            GavinRecord nextResult;
            LinkedHashMap<String, Iterator<GavinRecord>> resultBatches;
            HashMap<String, List<GavinRecord>> variantBuffer = new HashMap();
            Set<String> underlyingGenesForPreviousVariant = new HashSet<String>();
            List<String> positionCheck = new ArrayList<String>();

            @Override
            public boolean hasNext() {
                GavinRecord nextFromResultBatches = ConvertToGeneStream.this.getNextFromResultBatches(this.resultBatches, this.positionCheck);
                if (nextFromResultBatches != null) {
                    LOG.debug("[ConvertToGeneStream] Flushing next variant: {}", (Object)nextFromResultBatches.toStringShort());
                    this.nextResult = nextFromResultBatches;
                    return true;
                }
                while (ConvertToGeneStream.this.gavinRecordIterator.hasNext()) {
                    List<GavinRecord> variants;
                    if (this.resultBatches != null) {
                        LOG.debug("[ConvertToGeneStream] Flush complete, cleanup of genes: {}", (Object)this.resultBatches.keySet());
                        for (String string : this.resultBatches.keySet()) {
                            ArrayList<String> removeVariantsByPosition = new ArrayList<String>(this.variantBuffer.get(string).size());
                            for (GavinRecord gavinRecord : this.variantBuffer.get(string)) {
                                removeVariantsByPosition.add(gavinRecord.getChrPosRefAlt());
                            }
                            for (Map.Entry entry : this.variantBuffer.entrySet()) {
                                ((List)entry.getValue()).removeIf(rlvToCheck -> removeVariantsByPosition.contains(rlvToCheck.getChrPosRefAlt()));
                            }
                            this.variantBuffer.remove(string);
                        }
                        this.positionCheck.clear();
                        this.resultBatches = null;
                    }
                    GavinRecord gavinRecord = (GavinRecord)ConvertToGeneStream.this.gavinRecordIterator.next();
                    int n = gavinRecord.getPosition();
                    ConvertToGeneStream.this.positionalOrder.add(n);
                    Set<String> underlyingGenesForCurrentVariant = gavinRecord.getGenes();
                    LOG.debug("[ConvertToGeneStream] Assessing next variant: " + gavinRecord.toStringShort());
                    block4: for (String string : underlyingGenesForCurrentVariant) {
                        if (gavinRecord.isRelevant()) {
                            for (Relevance rlv : gavinRecord.getRelevance()) {
                                if (!rlv.getGene().equals(string)) continue;
                                List<GavinRecord> variants2 = this.variantBuffer.get(string);
                                if (variants2 == null) {
                                    variants2 = new ArrayList<GavinRecord>();
                                }
                                this.variantBuffer.put(string, variants2);
                                variants2.add(gavinRecord);
                                LOG.debug("[ConvertToGeneStream] Adding variant for matching relevant gene {}", (Object)string);
                                continue block4;
                            }
                            continue;
                        }
                        variants = this.variantBuffer.get(string);
                        if (variants == null) {
                            variants = new ArrayList<GavinRecord>();
                        }
                        variants.add(gavinRecord);
                        this.variantBuffer.put(string, variants);
                    }
                    this.resultBatches = new LinkedHashMap();
                    for (String string : this.underlyingGenesForPreviousVariant) {
                        if (underlyingGenesForCurrentVariant.contains(string) || this.variantBuffer.get(string) == null || this.variantBuffer.get(string).isEmpty()) continue;
                        LOG.debug("[ConvertToGeneStream] Gene " + string + " ended, creating result batch. Putting " + this.variantBuffer.get(string).size() + " variants in output batch");
                        variants = this.variantBuffer.get(string);
                        this.resultBatches.put(string, variants.iterator());
                    }
                    this.underlyingGenesForPreviousVariant.clear();
                    this.underlyingGenesForPreviousVariant.addAll(underlyingGenesForCurrentVariant);
                    if (!this.resultBatches.isEmpty()) {
                        this.nextResult = ConvertToGeneStream.this.getNextFromResultBatches(this.resultBatches, this.positionCheck);
                        LOG.debug("[ConvertToGeneStream] Flushing first variant of result batch: {}", (Object)this.nextResult.toStringShort());
                        return true;
                    }
                    this.resultBatches = null;
                }
                this.resultBatches = new LinkedHashMap();
                for (Map.Entry entry : this.variantBuffer.entrySet()) {
                    List gavinRecords = (List)entry.getValue();
                    if (gavinRecords.isEmpty()) continue;
                    this.resultBatches.put((String)entry.getKey(), gavinRecords.iterator());
                }
                if (this.resultBatches.size() > 0) {
                    this.nextResult = ConvertToGeneStream.this.getNextFromResultBatches(this.resultBatches, this.positionCheck);
                    if (this.nextResult != null) {
                        LOG.debug("[ConvertToGeneStream] Flushing first of remaining variants: " + this.nextResult.toStringShort());
                        return true;
                    }
                }
                return false;
            }

            @Override
            public GavinRecord next() {
                return this.nextResult;
            }
        };
    }

    private GavinRecord getNextFromResultBatches(LinkedHashMap<String, Iterator<GavinRecord>> resultBatches, List<String> positionAltsAlreadyReturned) {
        if (resultBatches == null) {
            return null;
        }
        for (Map.Entry<String, Iterator<GavinRecord>> entry : resultBatches.entrySet()) {
            Iterator<GavinRecord> gavinRecordsIterator = entry.getValue();
            while (gavinRecordsIterator.hasNext()) {
                GavinRecord next = gavinRecordsIterator.next();
                if (positionAltsAlreadyReturned.contains(next.getChrPosRefAlt())) continue;
                LOG.debug("Positions seen {} does not contain {}, so we output it", (Object)positionAltsAlreadyReturned, (Object)next.getChrPosRefAlt());
                positionAltsAlreadyReturned.add(next.getChrPosRefAlt());
                return next;
            }
        }
        return null;
    }
}

