/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.makervcf.genestream.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.molgenis.data.annotation.makervcf.structs.GavinRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertBackToPositionalStream {
    private static final Logger LOG = LoggerFactory.getLogger(ConvertBackToPositionalStream.class);
    private Iterator<GavinRecord> gavinRecordIterator;
    private List<Integer> order;

    public ConvertBackToPositionalStream(Iterator<GavinRecord> gavinRecordIterator, List<Integer> order) {
        this.gavinRecordIterator = gavinRecordIterator;
        this.order = order;
    }

    public Iterator<GavinRecord> go() {
        return new Iterator<GavinRecord>(){
            TreeMap<Integer, ArrayList<GavinRecord>> buffer = new TreeMap();
            Iterator<GavinRecord> bufferPrinter;
            GavinRecord nextResult;
            int i = -1;

            @Override
            public boolean hasNext() {
                if (this.bufferPrinter != null && this.bufferPrinter.hasNext()) {
                    LOG.debug("[ConvertBackToPositionalStream] Returning next element in the buffer");
                    this.nextResult = this.bufferPrinter.next();
                    return true;
                }
                block2: while (ConvertBackToPositionalStream.this.gavinRecordIterator.hasNext()) {
                    GavinRecord gavinRecord = (GavinRecord)ConvertBackToPositionalStream.this.gavinRecordIterator.next();
                    try {
                        ++this.i;
                        int pos = gavinRecord.getPosition();
                        if (pos == (Integer)ConvertBackToPositionalStream.this.order.get(this.i)) {
                            if (this.buffer.size() == 0) {
                                LOG.debug("[ConvertBackToPositionalStream] Buffer empty, returning current element {}", (Object)pos);
                                this.nextResult = gavinRecord;
                                return true;
                            }
                            if (this.buffer.containsKey(pos)) {
                                this.buffer.get(pos).add(gavinRecord);
                            } else {
                                this.buffer.put(pos, new ArrayList<GavinRecord>(Collections.singletonList(gavinRecord)));
                            }
                            LOG.debug("[ConvertBackToPositionalStream] Buffer size > 0, adding to buffer {}", (Object)pos);
                            for (Integer checkPos : this.buffer.keySet()) {
                                if (checkPos <= pos) continue;
                                continue block2;
                            }
                            this.bufferPrinter = ConvertBackToPositionalStream.this.getIterator(this.buffer);
                            LOG.debug("[ConvertBackToPositionalStream] Positions aligned again at {}, all values smaller than current pos, so clearning buffer with {} elements", (Object)pos, (Object)this.buffer.size());
                            this.buffer = new TreeMap();
                            this.nextResult = this.bufferPrinter.next();
                            return true;
                        }
                        LOG.debug("[ConvertBackToPositionalStream] Adding to buffer {}", (Object)pos);
                        if (this.buffer.containsKey(pos)) {
                            this.buffer.get(pos).add(gavinRecord);
                            continue;
                        }
                        this.buffer.put(pos, new ArrayList<GavinRecord>(Collections.singletonList(gavinRecord)));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                this.bufferPrinter = ConvertBackToPositionalStream.this.getIterator(this.buffer);
                if (this.bufferPrinter.hasNext()) {
                    LOG.debug("[ConvertBackToPositionalStream] Clearing last elements from buffer");
                    this.buffer = new TreeMap();
                    this.nextResult = this.bufferPrinter.next();
                    return true;
                }
                return false;
            }

            @Override
            public GavinRecord next() {
                return this.nextResult;
            }
        };
    }

    private Iterator<GavinRecord> getIterator(TreeMap<Integer, ArrayList<GavinRecord>> buffer) {
        ArrayList variants = new ArrayList();
        for (Map.Entry<Integer, ArrayList<GavinRecord>> entry : buffer.entrySet()) {
            variants.addAll(entry.getValue());
        }
        return variants.iterator();
    }
}

