/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.makervcf;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.calibratecadd.support.GavinUtils;
import org.molgenis.data.annotation.makervcf.VcfRecordMapper;
import org.molgenis.data.annotation.makervcf.VcfRecordMapperSettings;
import org.molgenis.data.annotation.makervcf.structs.GavinRecord;
import org.molgenis.vcf.VcfReader;
import org.molgenis.vcf.VcfWriter;
import org.molgenis.vcf.VcfWriterFactory;
import org.molgenis.vcf.meta.VcfMeta;
import org.molgenis.vcf.meta.VcfMetaInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WriteToRVCF {
    private static final Logger LOG = LoggerFactory.getLogger(WriteToRVCF.class);
    public static final String STRING = "String";

    WriteToRVCF() {
    }

    void writeRVCF(Iterator<GavinRecord> gavinRecords, File writeTo, File inputVcfFile, String version, String cmdString, boolean writeToDisk, boolean splitRlvField, boolean includeSamples) throws Exception {
        VcfMeta vcfMeta = this.createRvcfMeta(inputVcfFile, splitRlvField, includeSamples);
        vcfMeta.add("GavinVersion", StringUtils.wrap(version, "\""));
        vcfMeta.add("GavinCmd", StringUtils.wrap(cmdString, "\""));
        LOG.debug("[WriteToRVCF] Writing header");
        try (VcfWriter vcfWriter = new VcfWriterFactory().create(writeTo, vcfMeta);){
            VcfRecordMapperSettings vcfRecordMapperSettings = VcfRecordMapperSettings.create(includeSamples, splitRlvField);
            VcfRecordMapper vcfRecordMapper = new VcfRecordMapper(vcfMeta, vcfRecordMapperSettings);
            while (gavinRecords.hasNext()) {
                GavinRecord gavinRecord = gavinRecords.next();
                if (!writeToDisk) continue;
                LOG.debug("[WriteToRVCF] Writing VCF record");
                vcfWriter.write(vcfRecordMapper.map(gavinRecord));
            }
        }
    }

    private VcfMeta createRvcfMeta(File inputVcfFile, boolean isSeparateFields, boolean includeSamples) throws IOException {
        VcfMeta vcfMeta;
        try (VcfReader vcfReader = GavinUtils.getVcfReader(inputVcfFile);){
            vcfMeta = vcfReader.getVcfMeta();
        }
        if (!includeSamples) {
            vcfMeta.setColNames(Arrays.copyOfRange(vcfMeta.getColNames(), 0, 8));
            vcfMeta.setVcfMetaSamples(Collections.emptyMap());
        }
        if (!isSeparateFields) {
            this.addInfoField(vcfMeta, "RLV", ".", STRING, "Allele | AlleleFreq | Gene | FDR | Transcript | Phenotype | PhenotypeInheritance | PhenotypeOnset | PhenotypeDetails | PhenotypeGroup | SampleStatus | SamplePhenotype | SampleGenotype | SampleGroup | VariantSignificance | VariantSignificanceSource | VariantSignificanceJustification | VariantCompoundHet | VariantGroup");
        } else {
            this.addInfoField(vcfMeta, "RLV_PRESENT", "1", STRING, "\"RLV present\"");
            this.addInfoField(vcfMeta, "RLV_ALLELE", "1", STRING, "\"Allele\"");
            this.addInfoField(vcfMeta, "RLV_ALLELEFREQ", "1", STRING, "\"AlleleFreq\"");
            this.addInfoField(vcfMeta, "RLV_GENE", "1", STRING, "\"Gene\"");
            this.addInfoField(vcfMeta, "RLV_FDR", "1", STRING, "\"FDR\"");
            this.addInfoField(vcfMeta, "RLV_TRANSCRIPT", "1", STRING, "\"Transcript\"");
            this.addInfoField(vcfMeta, "RLV_PHENOTYPE", "1", STRING, "\"Phenotype\"");
            this.addInfoField(vcfMeta, "RLV_PHENOTYPEINHERITANCE", "1", STRING, "\"PhenotypeInheritance\"");
            this.addInfoField(vcfMeta, "RLV_PHENOTYPEONSET", "1", STRING, "\"PhenotypeOnset\"");
            this.addInfoField(vcfMeta, "RLV_PHENOTYPEDETAILS", "1", STRING, "\"PhenotypeDetails\"");
            this.addInfoField(vcfMeta, "RLV_PHENOTYPEGROUP", "1", STRING, "\"PhenotypeGroup\"");
            this.addInfoField(vcfMeta, "RLV_SAMPLESTATUS", "1", STRING, "\"SampleStatus\"");
            this.addInfoField(vcfMeta, "RLV_SAMPLEPHENOTYPE", "1", STRING, "\"SamplePhenotype\"");
            this.addInfoField(vcfMeta, "RLV_SAMPLEGENOTYPE", "1", STRING, "\"SampleGenotype\"");
            this.addInfoField(vcfMeta, "RLV_SAMPLEGROUP", "1", STRING, "\"SampleGroup\"");
            this.addInfoField(vcfMeta, "RLV_VARIANTSIGNIFICANCE", "1", STRING, "\"VariantSignificance\"");
            this.addInfoField(vcfMeta, "RLV_VARIANTSIGNIFICANCESOURCE", "1", STRING, "\"VariantSignificanceSource\"");
            this.addInfoField(vcfMeta, "RLV_VARIANTSIGNIFICANCEJUSTIFICATION", "1", STRING, "\"VariantSignificanceJustification\"");
            this.addInfoField(vcfMeta, "RLV_VARIANTMULTIGENIC", "1", STRING, "\"VariantCompoundHet\"");
            this.addInfoField(vcfMeta, "RLV_VARIANTGROUP", "1", STRING, "\"VariantGroup\"");
        }
        return vcfMeta;
    }

    private void addInfoField(VcfMeta vcfMeta, String id, String number, String type, String description) {
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        properties.put("ID", id);
        properties.put("Number", number);
        properties.put("Type", type);
        properties.put("Description", description);
        vcfMeta.addInfoMeta(new VcfMetaInfo(properties));
    }
}

