/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.makervcf;

import ch.qos.logback.classic.Level;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.commons.lang.StringUtils;
import org.molgenis.data.annotation.makervcf.Pipeline;
import org.molgenis.data.annotation.makervcf.VersionUtils;
import org.molgenis.data.annotation.makervcf.util.HandleMissingCaddScores;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger LOG = LoggerFactory.getLogger(Main.class);
    public static final String INPUT = "input";
    public static final String OUTPUT = "output";
    public static final String GAVIN = "gavin";
    public static final String REPPATHO = "reppatho";
    public static final String CGD = "cgd";
    public static final String FDR = "fdr";
    public static final String CADD = "cadd";
    public static final String LAB = "lab";
    public static final String MODE = "mode";
    public static final String VERBOSE = "verbose";
    public static final String REPLACE = "replace";
    public static final String HELP = "help";
    public static final String RESTORE = "restore";
    public static final String SPLIT_RLV_FIELD = "separate_fields";
    public static final String KEEP_ALL_VARIANTS = "keep_all_variants";
    public static final String INCLUDE_SAMPLES = "include_samples";

    public static void main(String[] args) throws Exception {
        OptionParser parser = Main.createOptionParser();
        OptionSet options = parser.parse(args);
        new Main().run(options, parser, Arrays.toString(args));
    }

    private static OptionParser createOptionParser() {
        OptionParser parser = new OptionParser();
        parser.acceptsAll(Arrays.asList("i", INPUT), "Input VCF file").withRequiredArg().ofType(File.class);
        parser.acceptsAll(Arrays.asList("o", OUTPUT), "Output RVCF file").withRequiredArg().ofType(File.class);
        parser.acceptsAll(Arrays.asList("g", GAVIN), "GAVIN calibration file").withRequiredArg().ofType(File.class);
        parser.acceptsAll(Arrays.asList("p", REPPATHO), "VCF file containing reported pathogenic/likely pathogenic variants").withRequiredArg().ofType(File.class);
        parser.acceptsAll(Arrays.asList("d", CGD), "CGD file").withRequiredArg().ofType(File.class);
        parser.acceptsAll(Arrays.asList("f", FDR), "Gene-specific FDR file").withRequiredArg().ofType(File.class);
        parser.acceptsAll(Arrays.asList("c", CADD), "Input/output CADD missing annotations").withRequiredArg().ofType(File.class);
        parser.acceptsAll(Arrays.asList("l", LAB), "VCF file with custom lab specific variant classifications").withOptionalArg().ofType(File.class);
        parser.acceptsAll(Arrays.asList("m", MODE), "Create or use CADD file for missing annotations, either " + HandleMissingCaddScores.Mode.ANALYSIS.toString() + " or " + HandleMissingCaddScores.Mode.CREATEFILEFORCADD.toString()).withRequiredArg().ofType(String.class);
        parser.acceptsAll(Arrays.asList("v", VERBOSE), "Verbally express what is happening underneath the programmatic hood.");
        parser.acceptsAll(Arrays.asList("r", REPLACE), "Enables output RVCF and CADD intermediate file override, replacing a file with the same name as the argument for the -o option");
        parser.acceptsAll(Arrays.asList("h", HELP), "Prints this help text");
        parser.acceptsAll(Arrays.asList("e", RESTORE), "[not available] Supporting tool. Combine RVCF results with original VCF.").withOptionalArg().ofType(File.class);
        parser.acceptsAll(Arrays.asList("k", KEEP_ALL_VARIANTS), "Do not filter the non relevant variants, return all variants from the input");
        parser.acceptsAll(Arrays.asList("s", INCLUDE_SAMPLES), "Include samples is output");
        parser.acceptsAll(Arrays.asList("q", SPLIT_RLV_FIELD), "Create separate INFO fields for every part of the RLV information");
        return parser;
    }

    private void printHelp(String version, String title, OptionParser parser) throws IOException {
        System.out.println("Detect likely relevant clinical variants and matching samples in a VCF file.\nYour input VCF must be fully annotated with SnpEff, ExAC frequencies and CADD scores, and optionally frequencies from GoNL and 1000G.\nThis can be done with MOLGENIS CmdlineAnnotator, available at https://github.com/molgenis/molgenis/releases/download/v1.21.1/CmdLineAnnotator-1.21.1.jar\nPlease report any bugs, issues and feature requests at https://github.com/molgenis/gavin-plus\n\nTypical usage: java -jar GAVIN-Plus-" + version + ".jar [inputfile] [outputfile] [helperfiles] [mode/flags]\nExample usage:\njava -Xmx4g -jar GAVIN-Plus-" + version + ".jar \\\n-i patient76.snpeff.exac.gonl.caddsnv.vcf \\\n-o patient76_RVCF.vcf \\\n-g GAVIN_calibrations_r0.5.tsv \\\n-p clinvar.vkgl.patho.26june2018.vcf.gz \\\n-d CGD_26jun2018.txt.gz \\\n-f FDR_allGenes_r1.2.tsv \\\n-c fromCadd.tsv \\\n-m ANALYSIS \n\nDealing with CADD intermediate files:\nYou first want to generate a intermediate file with any missing CADD annotations using '-d toCadd.tsv -m CREATEFILEFORCADD'\nAfter which, you want to score the variants in toCadd.tsv with the web service at http://cadd.gs.washington.edu/score\nThe resulting scored file should be unpacked and then used for analysis with '-d fromCadd.tsv -m ANALYSIS'\n\nDetails on the various helper files:\nThe required helper files for -g, -c, -d and -f can be downloaded from: http://molgenis.org/downloads/gavin at 'data_bundle'.\nThe -a file is either produced by the analysis (using -m CREATEFILEFORCADD) or used as an existing file (using -m ANALYSIS).\nThe -l is a user-supplied VCF of interpreted variants. Use 'CLSF=LP' or 'CLSF=P' as info field to denote (likely) pathogenic variants.\n\nUsing pedigree data for filtering:\nPlease use the standard PEDIGREE notation in your VCF header, e.g. '##PEDIGREE=<Child=p01,Mother=p02,Father=p03>'. Trios and duos are allowed.\nParents are assumed unaffected, children affected. Using complex family trees, grandparents and siblings is not yet supported.\n\nSome other notes:\nPhased genotypes are used to remove obvious false compound heterozygous hits. These are demoted to heterozygous multihit.\nIf GoNL annotations are provided, variants above 5% MAF are removed as presumed false positives (in addition to ExAC >5%).\nThe gene FDR values are based on 2,504 individuals from The 1000 Genomes project and may be used as a general indication of significance -\nhowever - high FDR values may be caused by either faulty detection OR false positives from the low-coverage sequencing data.\n" + StringUtils.repeat("-", title.length()) + "\n\nAvailable options:\n");
        parser.printHelpOn(System.out);
        System.out.println("\n" + StringUtils.repeat("-", title.length()) + "\n");
    }

    public void run(OptionSet options, OptionParser parser, String cmdString) throws Exception {
        String modeString;
        File gavinFile;
        String version = VersionUtils.getVersion();
        String title = "* MOLGENIS GAVIN+ for genome diagnostics, release " + version + "";
        String titl2 = "* Gene-Aware Variant INterpretation Plus";
        int len = Math.max(title.length(), titl2.length());
        String appTitle = "\n" + StringUtils.repeat("*", len) + "\n" + title + "\n" + titl2 + "\n" + StringUtils.repeat("*", len) + "\n";
        System.out.println(appTitle);
        if (!(options.has(RESTORE) && options.has(INPUT) && options.has(OUTPUT) || options.has(INPUT) && options.has(OUTPUT) && options.has(GAVIN) && options.has(REPPATHO) && options.has(CGD) && options.has(FDR) && options.has(CADD) && options.has(MODE))) {
            if (options.has(HELP)) {
                System.out.println("Help page requested.");
                this.printHelp(version, title, parser);
                return;
            }
            System.out.println("Bad arguments. Showing help:");
            this.printHelp(version, title, parser);
            return;
        }
        System.out.println("Arguments OK.");
        if (options.has(RESTORE)) {
            System.out.println("Restore mode not yet supported!");
            return;
        }
        File inputVcfFile = (File)options.valueOf(INPUT);
        if (!inputVcfFile.exists()) {
            System.out.println("Input VCF file not found at " + inputVcfFile);
            return;
        }
        if (inputVcfFile.isDirectory()) {
            System.out.println("Input VCF file is a directory, not a file!");
            return;
        }
        File outputVCFFile = (File)options.valueOf(OUTPUT);
        if (outputVCFFile.exists()) {
            if (options.has(REPLACE)) {
                System.out.println("Override enabled, replacing existing output RVCF file with specified output: " + outputVCFFile.getAbsolutePath());
            } else {
                System.out.println("Output RVCF file already exists, please either enter a different output name or use the '-r' option to overwrite the output file.");
                return;
            }
        }
        if (!(gavinFile = (File)options.valueOf(GAVIN)).exists()) {
            System.out.println("GAVIN calibration file not found at " + gavinFile);
            return;
        }
        if (gavinFile.isDirectory()) {
            System.out.println("GAVIN calibration file location is a directory, not a file!");
            return;
        }
        File repPathoFile = (File)options.valueOf(REPPATHO);
        if (!repPathoFile.exists()) {
            System.out.println("VCF file (containing reported LP/P variants) not found at " + repPathoFile);
            return;
        }
        if (repPathoFile.isDirectory()) {
            System.out.println("VCF file (containing reported LP/P variants) location is a directory, not a file!");
            return;
        }
        File cgdFile = (File)options.valueOf(CGD);
        if (!cgdFile.exists()) {
            System.out.println("CGD file not found at " + cgdFile);
            return;
        }
        if (cgdFile.isDirectory()) {
            System.out.println("CGD file location is a directory, not a file!");
            return;
        }
        File fdrFile = (File)options.valueOf(FDR);
        if (!fdrFile.exists()) {
            System.out.println("FDR file not found at " + fdrFile);
            return;
        }
        if (fdrFile.isDirectory()) {
            System.out.println("FDR file location is a directory, not a file!");
            return;
        }
        File labVariants = null;
        if (options.has(LAB)) {
            labVariants = (File)options.valueOf(LAB);
            if (!labVariants.exists()) {
                System.out.println("VCF file with lab specific variant classifications not found at " + labVariants);
                return;
            }
            if (labVariants.isDirectory()) {
                System.out.println("VCF file location with lab specific variant classifications is a directory, not a file!");
                return;
            }
        }
        if (!Main.isValidEnum(HandleMissingCaddScores.Mode.class, modeString = (String)options.valueOf(MODE))) {
            System.out.println("Mode must be one of the following: " + Arrays.toString((Object[])HandleMissingCaddScores.Mode.values()));
            return;
        }
        HandleMissingCaddScores.Mode mode = HandleMissingCaddScores.Mode.valueOf(modeString);
        File caddFile = (File)options.valueOf(CADD);
        if (mode == HandleMissingCaddScores.Mode.ANALYSIS) {
            if (!caddFile.exists()) {
                System.out.println("CADD intermediate file not found at" + caddFile.getAbsolutePath());
                return;
            }
            if (caddFile.isDirectory()) {
                System.out.println("CADD intermediate file location is a directory, not a file!");
                return;
            }
            if (!caddFile.getName().endsWith(".tsv")) {
                System.out.println("CADD intermediate file location extension expected to end in *.tsv, do not supply a gzipped file");
                return;
            }
        } else if (mode == HandleMissingCaddScores.Mode.CREATEFILEFORCADD && caddFile.exists()) {
            if (options.has(REPLACE)) {
                System.out.println("Override enabled, replacing existing CADD file with specified output: " + caddFile.getAbsolutePath());
            } else {
                System.out.println("CADD file already exists, please either enter a different output name or use the '-r' option to overwrite the output file.");
                return;
            }
        }
        if (options.has(VERBOSE)) {
            Main.setLogLevelToDebug();
        }
        boolean splitRlvField = false;
        if (options.has(SPLIT_RLV_FIELD)) {
            splitRlvField = true;
        }
        boolean keepAllVariants = false;
        if (options.has(KEEP_ALL_VARIANTS)) {
            keepAllVariants = true;
        }
        boolean includeSamples = false;
        if (options.has(INCLUDE_SAMPLES)) {
            includeSamples = true;
        }
        LOG.info("Starting..");
        Pipeline pipeline = new Pipeline(version, cmdString, splitRlvField, keepAllVariants, mode, inputVcfFile, gavinFile, repPathoFile, cgdFile, caddFile, fdrFile, outputVCFFile, labVariants, includeSamples);
        pipeline.start();
        LOG.info("..done!");
    }

    private static <E extends Enum<E>> boolean isValidEnum(Class<E> enumClass, String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(enumClass, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    private static void setLogLevelToDebug() {
        Logger logger = LoggerFactory.getLogger("org.molgenis");
        if (!(logger instanceof ch.qos.logback.classic.Logger)) {
            throw new RuntimeException("Root logger is not a Logback logger");
        }
        ch.qos.logback.classic.Logger logbackLogger = (ch.qos.logback.classic.Logger)logger;
        logbackLogger.setLevel(Level.DEBUG);
    }
}

