/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.annotation.entity.impl.gavin;

import javax.annotation.Nullable;
import org.molgenis.data.annotation.entity.impl.gavin.AutoValue_GavinThresholds;
import org.molgenis.data.annotation.entity.impl.gavin.Category;

public abstract class GavinThresholds {
    public static final String PATHO_MAF_THRESHOLD = "PathoMAFThreshold";
    public static final String MEAN_PATHOGENIC_CADD_SCORE = "MeanPathogenicCADDScore";
    public static final String MEAN_POPULATION_CADD_SCORE = "MeanPopulationCADDScore";
    public static final String SPEC_95TH_PER_CADD_THRESHOLD = "Spec95thPerCADDThreshold";
    public static final String SENS_95TH_PER_CADD_THRESHOLD = "Sens95thPerCADDThreshold";
    private static final String CATEGORY = "Category";

    @Nullable
    public abstract Double getPathoMAFThreshold();

    @Nullable
    public abstract Double getMeanPathogenicCADDScore();

    @Nullable
    public abstract Double getMeanPopulationCADDScore();

    @Nullable
    public abstract Double getSpec95thPerCADDThreshold();

    @Nullable
    public abstract Double getSens95thPerCADDThreshold();

    public abstract Category getCategory();

    public GavinThresholds withExtraSensitivity(int extraSensitivityFactor) {
        Double pathoMAFThreshold = this.getPathoMAFThreshold();
        Double meanPathogenicCADDScore = this.getMeanPathogenicCADDScore();
        Double meanPopulationCADDScore = this.getMeanPopulationCADDScore();
        Double spec95thPerCADDThreshold = this.getSpec95thPerCADDThreshold();
        Double sens95thPerCADDThreshold = this.getSens95thPerCADDThreshold();
        if (pathoMAFThreshold != null) {
            pathoMAFThreshold = pathoMAFThreshold * (double)extraSensitivityFactor * 2.0;
        }
        if (meanPathogenicCADDScore != null) {
            meanPathogenicCADDScore = meanPathogenicCADDScore - (double)extraSensitivityFactor;
        }
        if (meanPopulationCADDScore != null) {
            meanPopulationCADDScore = meanPopulationCADDScore - (double)extraSensitivityFactor;
        }
        if (spec95thPerCADDThreshold != null) {
            spec95thPerCADDThreshold = spec95thPerCADDThreshold - (double)extraSensitivityFactor;
        }
        if (sens95thPerCADDThreshold != null) {
            sens95thPerCADDThreshold = sens95thPerCADDThreshold - (double)extraSensitivityFactor;
        }
        return new AutoValue_GavinThresholds(pathoMAFThreshold, meanPathogenicCADDScore, meanPopulationCADDScore, spec95thPerCADDThreshold, sens95thPerCADDThreshold, this.getCategory());
    }

    public static GavinThresholds create(Double pathoMAFThreshold, Double meanPathogenicCADDScore, Double meanPopulationCADDScore, Double spec95thPerCADDThreshold, Double sens95thPerCADDThreshold, Category category) {
        return new AutoValue_GavinThresholds(pathoMAFThreshold, meanPathogenicCADDScore, meanPopulationCADDScore, spec95thPerCADDThreshold, sens95thPerCADDThreshold, category);
    }

    public boolean isAboveMeanPathogenicCADDScore(double caddScaled) {
        return this.getMeanPathogenicCADDScore() != null && caddScaled > this.getMeanPathogenicCADDScore();
    }

    public boolean isBelowMeanPopulationCADDScore(double caddScaled) {
        return this.getMeanPopulationCADDScore() != null && caddScaled < this.getMeanPopulationCADDScore();
    }

    public boolean isAbovePathoMAFThreshold(Double exacMAF) {
        return exacMAF != null && this.getPathoMAFThreshold() != null && exacMAF > this.getPathoMAFThreshold();
    }

    public boolean isAboveSpec95thPerCADDThreshold(double caddScaled) {
        return this.getSpec95thPerCADDThreshold() != null && caddScaled > this.getSpec95thPerCADDThreshold();
    }

    public boolean isBelowSens95PerCADDThreshold(double caddScaled) {
        return this.getSens95thPerCADDThreshold() != null && caddScaled < this.getSens95thPerCADDThreshold();
    }
}

