/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.cgd;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import org.molgenis.cgd.CGDEntry;

public class LoadCGD {
    public static Map<String, CGDEntry> loadCGD(File cgdFile) throws IOException {
        FileInputStream fileStream = new FileInputStream(cgdFile);
        GZIPInputStream gzipStream = new GZIPInputStream(fileStream);
        InputStreamReader decoder = new InputStreamReader((InputStream)gzipStream, "UTF-8");
        BufferedReader buffered = new BufferedReader(decoder);
        TreeMap<String, CGDEntry> cgd = new TreeMap<String, CGDEntry>(String.CASE_INSENSITIVE_ORDER);
        buffered.lines().forEach(line -> {
            String[] split = line.split("\t", -1);
            CGDEntry entry = new CGDEntry(split[0], split[1], split[2], split[3], split[4], split[5], split[6], split[7], split[8], split[9], split[10], split[11]);
            CGDEntry.generalizedInheritance inherMode = CGDEntry.generalizedInheritance.OTHER;
            if (split[4].contains("AD") && split[4].contains("AR")) {
                inherMode = CGDEntry.generalizedInheritance.DOMINANT_OR_RECESSIVE;
            } else if (split[4].contains("AR")) {
                inherMode = CGDEntry.generalizedInheritance.RECESSIVE;
            } else if (split[4].contains("AD")) {
                inherMode = CGDEntry.generalizedInheritance.DOMINANT;
            } else if (split[4].contains("BG")) {
                inherMode = CGDEntry.generalizedInheritance.BLOODGROUP;
            } else if (split[4].contains("XL")) {
                inherMode = CGDEntry.generalizedInheritance.X_LINKED;
            }
            entry.setGeneralizedInheritance(inherMode);
            cgd.put(split[0], entry);
        });
        buffered.close();
        return cgd;
    }

    public static void main(String[] args) throws IOException {
        Map<String, CGDEntry> cgd = LoadCGD.loadCGD(new File("/Users/joeri/github/gavin-plus/src/test/resources/bundle_r1.2/CGD_26jun2018.txt.gz"));
        for (String key : cgd.keySet()) {
            System.out.println(cgd.get(key).getGene() + "\t" + (Object)((Object)cgd.get(key).getGeneralizedInheritance()));
        }
    }
}

