/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.cgd;

import java.util.ArrayList;
import java.util.List;

public class CGDEntry {
    private String gene;
    private String hgnc_id;
    private String entrez_gene_id;
    private String condition;
    private String inheritance;
    private String age_group;
    private String allelicConditions;
    private String manifestationCategories;
    private List<String> manifestationCategoriesList;
    private String interventionCategories;
    private String comments;
    private String interventionOrRationale;
    private String references;
    private generalizedInheritance generalizedInheritance;

    public CGDEntry(String gene, String hgnc_id, String entrez_gene_id, String condition, String inheritance, String age_group, String allelicConditions, String manifestationCategories, String interventionCategories, String comments, String interventionOrRationale, String references) {
        this.gene = gene;
        this.hgnc_id = hgnc_id;
        this.entrez_gene_id = entrez_gene_id;
        this.condition = condition;
        this.inheritance = inheritance;
        this.age_group = age_group;
        this.allelicConditions = allelicConditions;
        this.manifestationCategories = manifestationCategories;
        this.interventionCategories = interventionCategories;
        this.comments = comments;
        this.interventionOrRationale = interventionOrRationale;
        this.references = references;
        ArrayList<String> manifestationCategoriesList = new ArrayList<String>();
        for (String manifestCat : manifestationCategories.split(";", -1)) {
            if (manifestCat.trim().equals("")) continue;
            manifestationCategoriesList.add(manifestCat.trim());
        }
        this.manifestationCategoriesList = manifestationCategoriesList;
    }

    public List<String> getManifestationCategoriesList() {
        return this.manifestationCategoriesList;
    }

    public String getGene() {
        return this.gene;
    }

    public String getHgnc_id() {
        return this.hgnc_id;
    }

    public String getEntrez_gene_id() {
        return this.entrez_gene_id;
    }

    public String getCondition() {
        return this.condition;
    }

    public String getInheritance() {
        return this.inheritance;
    }

    public String getAge_group() {
        return this.age_group;
    }

    public String getAllelicConditions() {
        return this.allelicConditions;
    }

    public String getManifestationCategories() {
        return this.manifestationCategories;
    }

    public String getInterventionCategories() {
        return this.interventionCategories;
    }

    public String getComments() {
        return this.comments;
    }

    public String getInterventionOrRationale() {
        return this.interventionOrRationale;
    }

    public String getReferences() {
        return this.references;
    }

    public generalizedInheritance getGeneralizedInheritance() {
        return this.generalizedInheritance;
    }

    public void setGeneralizedInheritance(generalizedInheritance generalizedInheritance2) {
        this.generalizedInheritance = generalizedInheritance2;
    }

    public String toString() {
        return this.gene + "\t" + this.hgnc_id + "\t" + this.entrez_gene_id + "\t" + this.condition + "\t" + this.inheritance + "\t" + this.age_group + "\t" + this.allelicConditions + "\t" + this.manifestationCategories + "\t" + this.interventionCategories + "\t" + this.comments + "\t" + this.interventionOrRationale + "\t" + this.references + "\t" + (Object)((Object)this.generalizedInheritance);
    }

    public static enum generalizedInheritance {
        DOMINANT,
        RECESSIVE,
        DOMINANT_OR_RECESSIVE,
        X_LINKED,
        BLOODGROUP,
        OTHER,
        NOTINCGD;


        public static boolean hasKnownInheritance(generalizedInheritance gi) {
            return gi == RECESSIVE || gi == DOMINANT || gi == DOMINANT_OR_RECESSIVE || gi == X_LINKED;
        }
    }
}

