/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.variantcontext.writer;

import java.util.HashMap;
import org.broadinstitute.variant.variantcontext.Genotype;

public class IntGenotypeFieldAccessors {
    private final HashMap<String, Accessor> intGenotypeFieldEncoders = new HashMap();

    public IntGenotypeFieldAccessors() {
        this.intGenotypeFieldEncoders.put("DP", new DPAccessor());
        this.intGenotypeFieldEncoders.put("AD", new ADAccessor());
        this.intGenotypeFieldEncoders.put("PL", new PLAccessor());
        this.intGenotypeFieldEncoders.put("GQ", new GQAccessor());
    }

    public Accessor getAccessor(String string) {
        return this.intGenotypeFieldEncoders.get(string);
    }

    public static class PLAccessor
    extends Accessor {
        @Override
        public int[] getValues(Genotype genotype) {
            return genotype.getPL();
        }
    }

    public static class ADAccessor
    extends Accessor {
        @Override
        public int[] getValues(Genotype genotype) {
            return genotype.getAD();
        }
    }

    public static class DPAccessor
    extends AtomicAccessor {
        @Override
        public int getValue(Genotype genotype) {
            return genotype.getDP();
        }
    }

    public static class GQAccessor
    extends AtomicAccessor {
        @Override
        public int getValue(Genotype genotype) {
            return Math.min(genotype.getGQ(), 99);
        }
    }

    private static abstract class AtomicAccessor
    extends Accessor {
        private final int[] singleton = new int[1];

        private AtomicAccessor() {
        }

        @Override
        public int[] getValues(Genotype genotype) {
            this.singleton[0] = this.getValue(genotype);
            return this.singleton[0] == -1 ? null : this.singleton;
        }

        public abstract int getValue(Genotype var1);
    }

    public static abstract class Accessor {
        public abstract int[] getValues(Genotype var1);

        public final int getSize(Genotype genotype) {
            int[] nArray = this.getValues(genotype);
            return nArray == null ? 0 : nArray.length;
        }
    }
}

