/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.variantcontext.writer;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.variant.bcf2.BCF2Type;
import org.broadinstitute.variant.bcf2.BCF2Utils;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.writer.BCF2Encoder;
import org.broadinstitute.variant.variantcontext.writer.BCF2FieldEncoder;
import org.broadinstitute.variant.variantcontext.writer.IntGenotypeFieldAccessors;
import org.broadinstitute.variant.vcf.VCFHeader;

public abstract class BCF2FieldWriter {
    private final VCFHeader header;
    private final BCF2FieldEncoder fieldEncoder;

    @Requires(value={"header != null", "fieldEncoder != null"})
    protected BCF2FieldWriter(VCFHeader vCFHeader, BCF2FieldEncoder bCF2FieldEncoder) {
        this.header = vCFHeader;
        this.fieldEncoder = bCF2FieldEncoder;
    }

    @Ensures(value={"result != null"})
    protected VCFHeader getHeader() {
        return this.header;
    }

    @Ensures(value={"result != null"})
    protected BCF2FieldEncoder getFieldEncoder() {
        return this.fieldEncoder;
    }

    @Ensures(value={"result != null"})
    protected String getField() {
        return this.getFieldEncoder().getField();
    }

    @Requires(value={"vc != null"})
    public void start(BCF2Encoder bCF2Encoder, VariantContext variantContext) throws IOException {
        this.fieldEncoder.writeFieldKey(bCF2Encoder);
    }

    public void done(BCF2Encoder bCF2Encoder, VariantContext variantContext) throws IOException {
    }

    public String toString() {
        return "BCF2FieldWriter " + this.getClass().getSimpleName() + " with encoder " + this.getFieldEncoder();
    }

    public static class GTWriter
    extends GenotypesWriter {
        final Map<Allele, Integer> alleleMapForTriPlus = new HashMap<Allele, Integer>(5);
        Allele ref;
        Allele alt1;

        public GTWriter(VCFHeader vCFHeader, BCF2FieldEncoder bCF2FieldEncoder) {
            super(vCFHeader, bCF2FieldEncoder);
        }

        @Override
        public void start(BCF2Encoder bCF2Encoder, VariantContext variantContext) throws IOException {
            if (variantContext.getNAlleles() > 127) {
                throw new IllegalStateException("Current BCF2 encoder cannot handle sites with > 127 alleles, but you have " + variantContext.getNAlleles() + " at " + variantContext.getChr() + ":" + variantContext.getStart());
            }
            this.encodingType = BCF2Type.INT8;
            this.buildAlleleMap(variantContext);
            this.nValuesPerGenotype = variantContext.getMaxPloidy(2);
            super.start(bCF2Encoder, variantContext);
        }

        @Override
        public void addGenotype(BCF2Encoder bCF2Encoder, VariantContext variantContext, Genotype genotype) throws IOException {
            int n = genotype.getPloidy();
            for (int i = 0; i < this.nValuesPerGenotype; ++i) {
                if (i < n) {
                    Allele allele = genotype.getAllele(i);
                    int n2 = this.getAlleleOffset(allele);
                    int n3 = n2 + 1 << 1 | (genotype.isPhased() ? 1 : 0);
                    bCF2Encoder.encodeRawBytes(n3, this.encodingType);
                    continue;
                }
                bCF2Encoder.encodeRawBytes(this.encodingType.getMissingBytes(), this.encodingType);
            }
        }

        @Requires(value={"a != null"})
        private final int getAlleleOffset(Allele allele) {
            if (allele == this.ref) {
                return 0;
            }
            if (allele == this.alt1) {
                return 1;
            }
            if (allele == Allele.NO_CALL) {
                return -1;
            }
            Integer n = this.alleleMapForTriPlus.get(allele);
            if (n == null) {
                throw new IllegalStateException("BUG: Couldn't find allele offset for allele " + allele);
            }
            return n;
        }

        private final void buildAlleleMap(VariantContext variantContext) {
            int n = variantContext.getNAlleles();
            this.ref = variantContext.getReference();
            Allele allele = this.alt1 = n > 1 ? variantContext.getAlternateAllele(0) : null;
            if (n > 2) {
                this.alleleMapForTriPlus.clear();
                List<Allele> list = variantContext.getAlleles();
                for (int i = 2; i < list.size(); ++i) {
                    this.alleleMapForTriPlus.put(list.get(i), i);
                }
            }
        }
    }

    public static class FTGenotypesWriter
    extends StaticallyTypeGenotypesWriter {
        public FTGenotypesWriter(VCFHeader vCFHeader, BCF2FieldEncoder bCF2FieldEncoder) {
            super(vCFHeader, bCF2FieldEncoder);
        }

        @Override
        public void addGenotype(BCF2Encoder bCF2Encoder, VariantContext variantContext, Genotype genotype) throws IOException {
            String string = genotype.getFilters();
            this.getFieldEncoder().encodeValue(bCF2Encoder, string, this.encodingType, this.nValuesPerGenotype);
        }

        @Override
        protected int numElements(VariantContext variantContext, Genotype genotype) {
            return this.getFieldEncoder().numElements(variantContext, genotype.getFilters());
        }
    }

    public static class IGFGenotypesWriter
    extends GenotypesWriter {
        final IntGenotypeFieldAccessors.Accessor ige;

        public IGFGenotypesWriter(VCFHeader vCFHeader, BCF2FieldEncoder bCF2FieldEncoder, IntGenotypeFieldAccessors.Accessor accessor) {
            super(vCFHeader, bCF2FieldEncoder);
            this.ige = accessor;
            if (!(bCF2FieldEncoder instanceof BCF2FieldEncoder.IntArray)) {
                throw new IllegalArgumentException("BUG: IntGenotypesWriter requires IntArray encoder for field " + this.getField());
            }
        }

        @Override
        public void start(BCF2Encoder bCF2Encoder, VariantContext variantContext) throws IOException {
            this.encodingType = BCF2Type.INT8;
            for (Genotype genotype : variantContext.getGenotypes()) {
                int[] nArray = this.ige.getValues(genotype);
                BCF2Type bCF2Type = this.getFieldEncoder().getType(nArray);
                this.encodingType = BCF2Utils.maxIntegerType(this.encodingType, bCF2Type);
                if (this.encodingType != BCF2Type.INT32) continue;
                break;
            }
            super.start(bCF2Encoder, variantContext);
        }

        @Override
        public void addGenotype(BCF2Encoder bCF2Encoder, VariantContext variantContext, Genotype genotype) throws IOException {
            this.getFieldEncoder().encodeValue(bCF2Encoder, this.ige.getValues(genotype), this.encodingType, this.nValuesPerGenotype);
        }

        @Override
        protected int numElements(VariantContext variantContext, Genotype genotype) {
            return this.ige.getSize(genotype);
        }
    }

    public static class IntegerTypeGenotypesWriter
    extends GenotypesWriter {
        public IntegerTypeGenotypesWriter(VCFHeader vCFHeader, BCF2FieldEncoder bCF2FieldEncoder) {
            super(vCFHeader, bCF2FieldEncoder);
        }

        @Override
        public void start(BCF2Encoder bCF2Encoder, VariantContext variantContext) throws IOException {
            ArrayList<Integer> arrayList = new ArrayList<Integer>(variantContext.getNSamples());
            for (Genotype genotype : variantContext.getGenotypes()) {
                for (Object object : BCF2Utils.toList(genotype.getExtendedAttribute(this.getField(), null))) {
                    if (object == null) continue;
                    arrayList.add((Integer)object);
                }
            }
            this.encodingType = BCF2Utils.determineIntegerType(arrayList);
            super.start(bCF2Encoder, variantContext);
        }
    }

    public static class StaticallyTypeGenotypesWriter
    extends GenotypesWriter {
        public StaticallyTypeGenotypesWriter(VCFHeader vCFHeader, BCF2FieldEncoder bCF2FieldEncoder) {
            super(vCFHeader, bCF2FieldEncoder);
            this.encodingType = this.getFieldEncoder().getStaticType();
        }
    }

    public static abstract class GenotypesWriter
    extends BCF2FieldWriter {
        int nValuesPerGenotype = -1;
        BCF2Type encodingType = null;

        protected GenotypesWriter(VCFHeader vCFHeader, BCF2FieldEncoder bCF2FieldEncoder) {
            super(vCFHeader, bCF2FieldEncoder);
            if (bCF2FieldEncoder.hasConstantNumElements()) {
                this.nValuesPerGenotype = this.getFieldEncoder().numElements();
            }
        }

        @Override
        @Requires(value={"encodingType != null", "nValuesPerGenotype >= 0 || ! getFieldEncoder().hasConstantNumElements()"})
        @Ensures(value={"nValuesPerGenotype >= 0"})
        public void start(BCF2Encoder bCF2Encoder, VariantContext variantContext) throws IOException {
            super.start(bCF2Encoder, variantContext);
            if (!this.getFieldEncoder().hasConstantNumElements()) {
                this.nValuesPerGenotype = this.getFieldEncoder().hasContextDeterminedNumElements() ? this.getFieldEncoder().numElements(variantContext) : this.computeMaxSizeOfGenotypeFieldFromValues(variantContext);
            }
            bCF2Encoder.encodeType(this.nValuesPerGenotype, this.encodingType);
        }

        @Requires(value={"encodingType != null", "nValuesPerGenotype >= 0"})
        public void addGenotype(BCF2Encoder bCF2Encoder, VariantContext variantContext, Genotype genotype) throws IOException {
            Object object = genotype.getExtendedAttribute(this.getField(), null);
            this.getFieldEncoder().encodeValue(bCF2Encoder, object, this.encodingType, this.nValuesPerGenotype);
        }

        @Ensures(value={"result >= 0"})
        protected int numElements(VariantContext variantContext, Genotype genotype) {
            return this.getFieldEncoder().numElements(variantContext, genotype.getExtendedAttribute(this.getField()));
        }

        @Ensures(value={"result >= 0"})
        private final int computeMaxSizeOfGenotypeFieldFromValues(VariantContext variantContext) {
            int n = -1;
            for (Genotype genotype : variantContext.getGenotypes()) {
                n = Math.max(n, this.numElements(variantContext, genotype));
            }
            return n;
        }
    }

    public static class GenericSiteWriter
    extends SiteWriter {
        public GenericSiteWriter(VCFHeader vCFHeader, BCF2FieldEncoder bCF2FieldEncoder) {
            super(vCFHeader, bCF2FieldEncoder);
        }

        @Override
        public void site(BCF2Encoder bCF2Encoder, VariantContext variantContext) throws IOException {
            Object object = variantContext.getAttribute(this.getField(), null);
            BCF2Type bCF2Type = this.getFieldEncoder().getType(object);
            if (object == null) {
                bCF2Encoder.encodeType(0, bCF2Type);
            } else {
                int n = this.getFieldEncoder().numElements(variantContext, object);
                bCF2Encoder.encodeType(n, bCF2Type);
                this.getFieldEncoder().encodeValue(bCF2Encoder, object, bCF2Type, n);
            }
        }
    }

    public static abstract class SiteWriter
    extends BCF2FieldWriter {
        protected SiteWriter(VCFHeader vCFHeader, BCF2FieldEncoder bCF2FieldEncoder) {
            super(vCFHeader, bCF2FieldEncoder);
        }

        public abstract void site(BCF2Encoder var1, VariantContext var2) throws IOException;
    }
}

