/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.util;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LittleEndianInputStream
extends FilterInputStream {
    byte[] buffer = new byte[8];

    public LittleEndianInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public byte readByte() throws IOException {
        int n = this.in.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public short readShort() throws IOException {
        int n = this.in.read();
        int n2 = this.in.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return (short)((n2 << 24 >>> 16) + (n << 24 >>> 24));
    }

    public int readInt() throws IOException {
        int n = this.in.read();
        int n2 = this.in.read();
        int n3 = this.in.read();
        int n4 = this.in.read();
        if (n4 < 0) {
            throw new EOFException();
        }
        return (n4 << 24) + (n3 << 24 >>> 8) + (n2 << 24 >>> 16) + (n << 24 >>> 24);
    }

    public long readLong() throws IOException {
        this.readFully(this.buffer);
        long l = this.buffer[0];
        long l2 = this.buffer[1];
        long l3 = this.buffer[2];
        long l4 = this.buffer[3];
        long l5 = this.buffer[4];
        long l6 = this.buffer[5];
        long l7 = this.buffer[6];
        long l8 = this.buffer[7];
        return (l8 << 56) + (l7 << 56 >>> 8) + (l6 << 56 >>> 16) + (l5 << 56 >>> 24) + (l4 << 56 >>> 32) + (l3 << 56 >>> 40) + (l2 << 56 >>> 48) + (l << 56 >>> 56);
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public String readString() throws IOException {
        byte by;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(100);
        while ((by = (byte)this.in.read()) != 0) {
            if (by < 0) {
                throw new EOFException();
            }
            byteArrayOutputStream.write(by);
        }
        return new String(byteArrayOutputStream.toByteArray());
    }

    private void readFully(byte[] byArray) throws IOException {
        int n;
        int n2 = byArray.length;
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < n2; i += n) {
            n = this.read(byArray, i, n2 - i);
            if (n >= 0) continue;
            throw new EOFException();
        }
    }
}

