/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import net.sf.samtools.util.ftp.FTPClient;
import net.sf.samtools.util.ftp.FTPStream;
import net.sf.samtools.util.ftp.FTPUtils;
import org.broad.tribble.util.URLHelper;

public class FTPHelper
implements URLHelper {
    private URL url;

    public FTPHelper(URL uRL) {
        if (!uRL.getProtocol().toLowerCase().equals("ftp")) {
            throw new IllegalArgumentException("FTPHelper can only be used with ftp protocol, not " + uRL.getProtocol());
        }
        this.url = uRL;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public long getContentLength() throws IOException {
        return FTPUtils.getContentLength(this.url);
    }

    @Override
    public InputStream openInputStream() throws IOException {
        String string = this.url.getPath();
        FTPClient fTPClient = FTPUtils.connect(this.url.getHost(), this.url.getUserInfo(), null);
        fTPClient.pasv();
        fTPClient.retr(string);
        return new FTPStream(fTPClient);
    }

    @Override
    public InputStream openInputStreamForRange(long l, long l2) throws IOException {
        throw new UnsupportedOperationException("Cannot perform range operations over FTP");
    }

    @Override
    public boolean exists() throws IOException {
        return FTPUtils.resourceAvailable(this.url);
    }
}

