/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.readers;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import org.broad.tribble.TribbleException;
import org.broad.tribble.readers.LineReader;
import org.broad.tribble.readers.LocationAware;
import org.broad.tribble.readers.LongLineBufferedReader;
import org.broad.tribble.readers.PositionalBufferedStream;

public class AsciiLineReader
implements LineReader,
LocationAware {
    private static final int BUFFER_OVERFLOW_INCREASE_FACTOR = 2;
    private static final byte LINEFEED = 10;
    private static final byte CARRIAGE_RETURN = 13;
    PositionalBufferedStream is;
    char[] lineBuffer;

    public AsciiLineReader(InputStream inputStream) {
        this(new PositionalBufferedStream(inputStream));
    }

    public AsciiLineReader(PositionalBufferedStream positionalBufferedStream) {
        this.is = positionalBufferedStream;
        this.lineBuffer = new char[10000];
    }

    @Override
    public long getPosition() {
        if (this.is == null) {
            throw new TribbleException("getPosition() called but no default stream was provided to the class on creation");
        }
        return this.is.getPosition();
    }

    public final String readLine(PositionalBufferedStream positionalBufferedStream) throws IOException {
        int n = 0;
        while (true) {
            int n2;
            if ((n2 = positionalBufferedStream.read()) == -1) {
                if (n > 0) {
                    return new String(this.lineBuffer, 0, n);
                }
                return null;
            }
            char c = (char)(n2 & 0xFF);
            if (c == '\n' || c == '\r') {
                if (c == '\r' && positionalBufferedStream.peek() == 10) {
                    positionalBufferedStream.read();
                }
                return new String(this.lineBuffer, 0, n);
            }
            if (n > this.lineBuffer.length - 3) {
                char[] cArray = new char[2 * this.lineBuffer.length];
                System.arraycopy(this.lineBuffer, 0, cArray, 0, this.lineBuffer.length);
                this.lineBuffer = cArray;
            }
            this.lineBuffer[n++] = c;
        }
    }

    @Override
    public final String readLine() throws IOException {
        if (this.is == null) {
            throw new TribbleException("readLine() called without an explicit stream argument but no default stream was provided to the class on creation");
        }
        return this.readLine(this.is);
    }

    @Override
    public void close() {
        if (this.is != null) {
            this.is.close();
        }
        this.lineBuffer = null;
    }

    public static void main(String[] stringArray) throws Exception {
        File file = new File(stringArray[0]);
        int n = Integer.valueOf(stringArray[1]);
        boolean bl = Boolean.valueOf(stringArray[2]);
        System.out.printf("Testing %s%n", stringArray[0]);
        for (int i = 0; i < n; ++i) {
            double d;
            long l;
            long l2;
            long l3;
            Closeable closeable;
            if (bl) {
                closeable = new BufferedReader(new FileReader(file));
                l3 = System.currentTimeMillis();
                l2 = 0L;
                while (((BufferedReader)closeable).readLine() != null) {
                    ++l2;
                }
                l = System.currentTimeMillis() - l3;
                d = (double)l2 / (double)l;
                AsciiLineReader.printStatus("BufferedReader", l2, d, l);
                ((BufferedReader)closeable).close();
            }
            if (bl) {
                closeable = new LongLineBufferedReader(new BufferedReader(new FileReader(file)));
                l3 = System.currentTimeMillis();
                l2 = 0L;
                while (((LongLineBufferedReader)closeable).readLine() != null) {
                    ++l2;
                }
                l = System.currentTimeMillis() - l3;
                d = (double)l2 / (double)l;
                AsciiLineReader.printStatus("BufferedReader", l2, d, l);
                ((LongLineBufferedReader)closeable).close();
            }
            closeable = new PositionalBufferedStream(new FileInputStream(file));
            AsciiLineReader asciiLineReader = new AsciiLineReader((PositionalBufferedStream)closeable);
            l3 = System.currentTimeMillis();
            l2 = 0L;
            while (asciiLineReader.readLine() != null) {
                ++l2;
            }
            l = System.currentTimeMillis() - l3;
            d = (double)l2 / (double)l;
            AsciiLineReader.printStatus("PositionalBufferedStream", l2, d, l);
            ((PositionalBufferedStream)closeable).close();
        }
    }

    private static final void printStatus(String string, long l, double d, long l2) {
        System.out.printf("%30s: %d lines read.  Rate = %.2e lines per second.  DT = %d%n", string, l, d, l2);
        System.out.flush();
    }
}

