/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.index.linear;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import org.broad.tribble.Feature;
import org.broad.tribble.index.Block;
import org.broad.tribble.index.Index;
import org.broad.tribble.index.IndexCreator;
import org.broad.tribble.index.linear.LinearIndex;

public class LinearIndexCreator
implements IndexCreator {
    public static int DEFAULT_BIN_WIDTH = 8000;
    private int binWidth = DEFAULT_BIN_WIDTH;
    private File inputFile;
    private LinkedList<LinearIndex.ChrIndex> chrList = new LinkedList();
    private int longestFeature = 0;
    private ArrayList<Block> blocks = new ArrayList();

    @Override
    public void initialize(File file, int n) {
        this.inputFile = file;
        this.binWidth = n;
    }

    @Override
    public void addFeature(Feature feature, long l) {
        if (this.chrList.size() == 0 || !this.chrList.getLast().getName().equals(feature.getChr())) {
            if (this.chrList.size() != 0) {
                for (int i = 0; i < this.blocks.size(); ++i) {
                    this.blocks.get(i).setEndPosition(i + 1 == this.blocks.size() ? l : this.blocks.get(i + 1).getStartPosition());
                    this.chrList.getLast().addBlock(this.blocks.get(i));
                }
            }
            this.chrList.add(new LinearIndex.ChrIndex(feature.getChr(), this.binWidth));
            this.blocks.clear();
            this.blocks.add(new Block(l, 0L));
            this.longestFeature = 0;
        }
        while (feature.getStart() > this.blocks.size() * this.binWidth) {
            this.blocks.add(new Block(l, 0L));
        }
        if (feature.getEnd() - feature.getStart() + 1 > this.longestFeature) {
            this.longestFeature = feature.getEnd() - feature.getStart() + 1;
            this.chrList.getLast().updateLongestFeature(this.longestFeature);
        }
        this.chrList.getLast().incrementFeatureCount();
    }

    @Override
    public Index finalizeIndex(long l) {
        if (l == 0L) {
            throw new IllegalArgumentException("finalFilePosition != 0, -> " + l);
        }
        for (int i = 0; i < this.blocks.size(); ++i) {
            this.blocks.get(i).setEndPosition(i + 1 == this.blocks.size() ? l : this.blocks.get(i + 1).getStartPosition());
            this.chrList.getLast().addBlock(this.blocks.get(i));
        }
        this.blocks.clear();
        LinearIndex linearIndex = new LinearIndex(this.chrList, this.inputFile);
        linearIndex.finalizeIndex();
        return linearIndex.optimize();
    }

    @Override
    public int defaultBinSize() {
        return DEFAULT_BIN_WIDTH;
    }

    @Override
    public int getBinSize() {
        return this.binWidth;
    }
}

