/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.index.interval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.broad.tribble.index.AbstractIndex;
import org.broad.tribble.index.Block;
import org.broad.tribble.index.IndexFactory;
import org.broad.tribble.index.interval.Interval;
import org.broad.tribble.index.interval.IntervalTree;
import org.broad.tribble.util.LittleEndianInputStream;
import org.broad.tribble.util.LittleEndianOutputStream;

public class IntervalTreeIndex
extends AbstractIndex {
    public IntervalTreeIndex() {
    }

    public IntervalTreeIndex(String string) {
        super(string);
    }

    @Override
    public Class getChrIndexClass() {
        return ChrIndex.class;
    }

    @Override
    protected int getType() {
        return IndexFactory.IndexType.INTERVAL_TREE.getHeaderValue();
    }

    public void insert(String string, Interval interval) {
        ChrIndex chrIndex = (ChrIndex)this.chrIndices.get(string);
        if (chrIndex == null) {
            chrIndex = new ChrIndex(string);
            this.chrIndices.put(string, chrIndex);
        }
        chrIndex.insert(interval);
    }

    protected void setChrIndex(List<ChrIndex> list) {
        for (ChrIndex chrIndex : list) {
            this.chrIndices.put(chrIndex.getName(), chrIndex);
        }
    }

    public void printTree() {
        for (String string : this.chrIndices.keySet()) {
            System.out.println(string + ":");
            ChrIndex chrIndex = (ChrIndex)this.chrIndices.get(string);
            chrIndex.printTree();
            System.out.println();
        }
    }

    public static class ChrIndex
    implements org.broad.tribble.index.ChrIndex {
        IntervalTree tree;
        String name;

        public ChrIndex() {
        }

        public ChrIndex(String string) {
            this.name = string;
            this.tree = new IntervalTree();
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void insert(Interval interval) {
            this.tree.insert(interval);
        }

        @Override
        public List<Block> getBlocks() {
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public List<Block> getBlocks(int n, int n2) {
            List<Interval> list = this.tree.findOverlapping(new Interval(n, n2));
            if (list == null || list.size() == 0) {
                return new ArrayList<Block>();
            }
            Block[] blockArray = new Block[list.size()];
            int n3 = 0;
            for (Interval object2 : list) {
                blockArray[n3++] = object2.getBlock();
            }
            Arrays.sort(blockArray, new Comparator<Block>(){

                @Override
                public int compare(Block block, Block block2) {
                    return block.getStartPosition() - block2.getStartPosition() < 1L ? -1 : (block.getStartPosition() - block2.getStartPosition() > 1L ? 1 : 0);
                }
            });
            ArrayList arrayList = new ArrayList(blockArray.length);
            Block block = blockArray[0];
            arrayList.add(block);
            for (int i = 1; i < blockArray.length; ++i) {
                void var7_9;
                Block block2 = blockArray[i];
                if (block2.getStartPosition() < var7_9.getEndPosition() + 1000L) {
                    var7_9.setEndPosition(block2.getEndPosition());
                    continue;
                }
                Block block3 = block2;
                arrayList.add(block3);
            }
            return arrayList;
        }

        public void printTree() {
            System.out.println(this.tree.toString());
        }

        @Override
        public void write(LittleEndianOutputStream littleEndianOutputStream) throws IOException {
            littleEndianOutputStream.writeString(this.name);
            List<Interval> list = this.tree.getIntervals();
            littleEndianOutputStream.writeInt(list.size());
            for (Interval interval : list) {
                littleEndianOutputStream.writeInt(interval.start);
                littleEndianOutputStream.writeInt(interval.end);
                littleEndianOutputStream.writeLong(interval.getBlock().getStartPosition());
                littleEndianOutputStream.writeInt((int)interval.getBlock().getSize());
            }
        }

        @Override
        public void read(LittleEndianInputStream littleEndianInputStream) throws IOException {
            this.tree = new IntervalTree();
            this.name = littleEndianInputStream.readString();
            int n = littleEndianInputStream.readInt();
            while (n-- > 0) {
                int n2 = littleEndianInputStream.readInt();
                int n3 = littleEndianInputStream.readInt();
                long l = littleEndianInputStream.readLong();
                int n4 = littleEndianInputStream.readInt();
                Interval interval = new Interval(n2, n3, new Block(l, n4));
                this.tree.insert(interval);
            }
        }
    }
}

