/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.example;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.broad.tribble.AbstractFeatureReader;
import org.broad.tribble.CloseableTribbleIterator;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.Tribble;
import org.broad.tribble.bed.BEDCodec;
import org.broad.tribble.dbsnp.OldDbSNPCodec;
import org.broad.tribble.gelitext.GeliTextCodec;
import org.broad.tribble.index.Index;
import org.broad.tribble.index.IndexFactory;
import org.broad.tribble.index.linear.LinearIndex;
import org.broad.tribble.util.LittleEndianOutputStream;

public class CountRecords {
    public static void main(String[] stringArray) {
        File file;
        if (stringArray.length > 2) {
            CountRecords.printUsage();
        }
        if (!(file = new File(stringArray[0])).exists()) {
            System.err.println("File " + file.getAbsolutePath() + " doesnt' exist");
            CountRecords.printUsage();
        }
        int n = stringArray.length == 2 ? Integer.valueOf(stringArray[1]) : -1;
        FeatureCodec featureCodec = CountRecords.getFeatureCodec(file);
        CountRecords.runWithIndex(file, featureCodec, n);
    }

    public static long runWithIndex(File file, FeatureCodec featureCodec, int n) {
        Index index = CountRecords.loadIndex(file, featureCodec);
        if (n != -1) {
            ((LinearIndex)index).optimize(n);
        }
        AbstractFeatureReader abstractFeatureReader = null;
        try {
            abstractFeatureReader = AbstractFeatureReader.getFeatureReader(file.getAbsolutePath(), featureCodec, index);
            long l = 0L;
            CloseableTribbleIterator closeableTribbleIterator = abstractFeatureReader.iterator();
            while (closeableTribbleIterator.hasNext()) {
                Feature feature = (Feature)closeableTribbleIterator.next();
                ++l;
            }
            System.err.println("We saw " + l + " record in file " + file);
            return l;
        }
        catch (IOException iOException) {
            throw new RuntimeException("Something went wrong while reading feature file " + file, iOException);
        }
    }

    public static void printUsage() {
        System.err.println("Usage: java -jar CountRecords.jar <inputFile>");
        System.err.println("    Where input can be of type: VCF (ends in .vcf or .VCF");
        System.err.println("                                Bed (ends in .bed or .bed");
        System.err.println("                                OldDbSNP (ends in .snp or .rod");
        System.exit(1);
    }

    public static Index loadIndex(File file, FeatureCodec featureCodec) {
        File file2 = Tribble.indexFile(file);
        Index index = null;
        if (file2.canRead()) {
            System.err.println("Loading index from disk for index file -> " + file2);
            index = IndexFactory.loadIndex(file2.getAbsolutePath());
        } else {
            System.err.println("Creating the index and memory, then writing to disk for index file -> " + file2);
            index = CountRecords.createAndWriteNewIndex(file, file2, featureCodec);
        }
        return index;
    }

    public static Index createAndWriteNewIndex(File file, File file2, FeatureCodec featureCodec) {
        try {
            Index index = IndexFactory.createLinearIndex(file, featureCodec);
            LittleEndianOutputStream littleEndianOutputStream = new LittleEndianOutputStream(new FileOutputStream(file2));
            index.write(littleEndianOutputStream);
            littleEndianOutputStream.close();
            return index;
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to create index from file " + file, iOException);
        }
    }

    public static FeatureCodec getFeatureCodec(File file) {
        if (file.getName().endsWith(".bed") || file.getName().endsWith(".BED")) {
            return new BEDCodec();
        }
        if (file.getName().endsWith(".snp") || file.getName().endsWith(".rod")) {
            return new OldDbSNPCodec();
        }
        if (file.getName().endsWith(".geli.calls") || file.getName().endsWith(".geli")) {
            return new GeliTextCodec();
        }
        throw new IllegalArgumentException("Unable to determine correct file type based on the file name, for file -> " + file);
    }
}

