/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import net.sf.samtools.util.IOUtil;
import net.sf.samtools.util.LineReader;
import net.sf.samtools.util.RuntimeIOException;

public class BufferedLineReader
implements LineReader {
    private final BufferedReader reader;
    private int lineNumber = 0;
    private String peekedLine;

    public BufferedLineReader(InputStream inputStream) {
        this(inputStream, IOUtil.STANDARD_BUFFER_SIZE);
    }

    public BufferedLineReader(InputStream inputStream, int n) {
        this.reader = new BufferedReader(new InputStreamReader(inputStream, Charset.forName("UTF-8")), n);
    }

    @Override
    public String readLine() {
        ++this.lineNumber;
        try {
            String string;
            if (this.peekedLine != null) {
                string = this.peekedLine;
                this.peekedLine = null;
            } else {
                string = this.reader.readLine();
            }
            return string;
        }
        catch (IOException iOException) {
            throw new RuntimeIOException(iOException);
        }
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int peek() {
        if (this.peekedLine == null) {
            try {
                this.peekedLine = this.reader.readLine();
            }
            catch (IOException iOException) {
                throw new RuntimeIOException(iOException);
            }
        }
        if (this.peekedLine == null) {
            return -1;
        }
        if (this.peekedLine.length() == 0) {
            return 10;
        }
        return this.peekedLine.charAt(0);
    }

    @Override
    public void close() {
        this.peekedLine = null;
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            throw new RuntimeIOException(iOException);
        }
    }
}

