/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import net.sf.samtools.BAMFileSpan;
import net.sf.samtools.BAMIndexContent;
import net.sf.samtools.BAMRecord;
import net.sf.samtools.CachingBAMFileIndex;
import net.sf.samtools.Chunk;
import net.sf.samtools.LinearIndex;
import net.sf.samtools.SAMException;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecordIterator;

public class BamIndexValidator {
    public static int exhaustivelyTestIndex(SAMFileReader sAMFileReader) {
        if (sAMFileReader.hasBrowseableIndex()) {
            CachingBAMFileIndex cachingBAMFileIndex = (CachingBAMFileIndex)sAMFileReader.getBrowseableIndex();
            int n = cachingBAMFileIndex.getNumberOfReferences();
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < n; ++i) {
                BAMIndexContent bAMIndexContent = cachingBAMFileIndex.getQueryResults(i);
                for (Chunk chunk : bAMIndexContent.getAllChunks()) {
                    SAMRecordIterator sAMRecordIterator = sAMFileReader.iterator(new BAMFileSpan(chunk));
                    ++n2;
                    BAMRecord bAMRecord = null;
                    try {
                        bAMRecord = (BAMRecord)sAMRecordIterator.next();
                        sAMRecordIterator.close();
                    }
                    catch (Exception exception) {
                        throw new SAMException("Exception in BamIndexValidator. Last good record " + bAMRecord + " in chunk " + chunk + " chunkCount=" + n2, exception);
                    }
                }
                LinearIndex linearIndex = bAMIndexContent.getLinearIndex();
                for (long l : linearIndex.getIndexEntries()) {
                    try {
                        if (l == 0L) continue;
                        SAMRecordIterator sAMRecordIterator = sAMFileReader.iterator(new BAMFileSpan(new Chunk(l, l + 1L)));
                        BAMRecord bAMRecord = (BAMRecord)sAMRecordIterator.next();
                        ++n3;
                        sAMRecordIterator.close();
                    }
                    catch (Exception exception) {
                        throw new SAMException("Exception in BamIndexValidator. Linear index access failure " + l + " indexCount=" + n3, exception);
                    }
                }
            }
            return n2;
        }
        return 0;
    }
}

