/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.sf.samtools.BAMIndexMetaData;
import net.sf.samtools.Bin;
import net.sf.samtools.Chunk;
import net.sf.samtools.LinearIndex;

class BAMIndexContent {
    private final int mReferenceSequence;
    private final BinList mBinList;
    private final BAMIndexMetaData mMetaData;
    private final LinearIndex mLinearIndex;

    BAMIndexContent(int n, Bin[] binArray, int n2, BAMIndexMetaData bAMIndexMetaData, LinearIndex linearIndex) {
        this.mReferenceSequence = n;
        this.mBinList = new BinList(binArray, n2);
        this.mMetaData = bAMIndexMetaData;
        this.mLinearIndex = linearIndex;
    }

    public int getReferenceSequence() {
        return this.mReferenceSequence;
    }

    public boolean containsBin(Bin bin) {
        return this.mBinList.getBin(bin.getBinNumber()) != null;
    }

    public BinList getBins() {
        return this.mBinList;
    }

    int getNumberOfNonNullBins() {
        return this.mBinList.getNumberOfNonNullBins();
    }

    public BAMIndexMetaData getMetaData() {
        return this.mMetaData;
    }

    public List<Chunk> getAllChunks() {
        ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
        for (Bin bin : this.mBinList) {
            if (bin.getChunkList() == null) continue;
            arrayList.addAll(bin.getChunkList());
        }
        return Collections.unmodifiableList(arrayList);
    }

    public LinearIndex getLinearIndex() {
        return this.mLinearIndex;
    }

    class BinList
    implements Iterable<Bin> {
        private final Bin[] mBinArray;
        public final int numberOfNonNullBins;
        public final int maxBinNumber;

        BinList(Bin[] binArray, int n) {
            this.mBinArray = binArray;
            this.numberOfNonNullBins = n;
            this.maxBinNumber = this.mBinArray.length - 1;
        }

        Bin getBin(int n) {
            if (n > this.maxBinNumber) {
                return null;
            }
            return this.mBinArray[n];
        }

        int getNumberOfNonNullBins() {
            return this.numberOfNonNullBins;
        }

        @Override
        public Iterator<Bin> iterator() {
            return new BinIterator();
        }

        private class BinIterator
        implements Iterator<Bin> {
            private int nextBin = 0;

            @Override
            public boolean hasNext() {
                while (this.nextBin <= BinList.this.maxBinNumber) {
                    if (BinList.this.getBin(this.nextBin) != null) {
                        return true;
                    }
                    ++this.nextBin;
                }
                return false;
            }

            @Override
            public Bin next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("This BinIterator is currently empty");
                }
                Bin bin = BinList.this.getBin(this.nextBin);
                ++this.nextBin;
                return bin;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Unable to remove from a bin iterator");
            }
        }
    }
}

