/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.vcf;

import java.io.File;
import java.util.EnumSet;
import java.util.Iterator;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.Log;
import net.sf.picard.util.ProgressLogger;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.util.CloserUtil;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.writer.Options;
import org.broadinstitute.variant.variantcontext.writer.VariantContextWriter;
import org.broadinstitute.variant.variantcontext.writer.VariantContextWriterFactory;
import org.broadinstitute.variant.vcf.VCFFileReader;
import org.broadinstitute.variant.vcf.VCFHeader;

public class VcfFormatConverter
extends CommandLineProgram {
    public static final Log LOG = Log.getInstance(VcfFormatConverter.class);
    @Usage
    public String USAGE = this.getStandardUsagePreamble() + "Convert a VCF file to a BCF file, or BCF to VCF.\n" + "" + "Input and output formats are determined by file extension.";
    @Option(doc="The BCF or VCF input file. The file format is determined by file extension.", shortName="I")
    public File INPUT;
    @Option(doc="The BCF or VCF output file. The file format is determined by file extension.", shortName="O")
    public File OUTPUT;
    @Option(doc="Fail if an index is not available for the input VCF/BCF")
    public Boolean REQUIRE_INDEX = true;

    public static void main(String[] stringArray) {
        new VcfFormatConverter().instanceMainWithExit(stringArray);
    }

    public VcfFormatConverter() {
        this.CREATE_INDEX = true;
    }

    @Override
    protected int doWork() {
        ProgressLogger progressLogger = new ProgressLogger(LOG, 10000);
        IoUtil.assertFileIsReadable(this.INPUT);
        IoUtil.assertFileIsWritable(this.OUTPUT);
        VCFFileReader vCFFileReader = new VCFFileReader(this.INPUT, this.REQUIRE_INDEX);
        VCFHeader vCFHeader = new VCFHeader(vCFFileReader.getFileHeader());
        SAMSequenceDictionary sAMSequenceDictionary = vCFHeader.getSequenceDictionary();
        if (this.CREATE_INDEX.booleanValue() && sAMSequenceDictionary == null) {
            throw new PicardException("A sequence dictionary must be available in the input file when creating indexed output.");
        }
        EnumSet<Options> enumSet = this.CREATE_INDEX != false ? EnumSet.of(Options.INDEX_ON_THE_FLY) : EnumSet.noneOf(Options.class);
        VariantContextWriter variantContextWriter = VariantContextWriterFactory.create(this.OUTPUT, sAMSequenceDictionary, enumSet);
        variantContextWriter.writeHeader(vCFHeader);
        Iterator iterator = vCFFileReader.iterator();
        while (iterator.hasNext()) {
            VariantContext variantContext = (VariantContext)iterator.next();
            variantContextWriter.add(variantContext);
            progressLogger.record(variantContext.getChr(), variantContext.getStart());
        }
        CloserUtil.close(iterator);
        CloserUtil.close(vCFFileReader);
        variantContextWriter.close();
        return 0;
    }
}

