/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import net.sf.picard.util.ReferenceSequenceMask;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMSequenceRecord;

public class WholeGenomeReferenceSequenceMask
implements ReferenceSequenceMask {
    SAMFileHeader header;

    public WholeGenomeReferenceSequenceMask(SAMFileHeader sAMFileHeader) {
        this.header = sAMFileHeader;
    }

    @Override
    public boolean get(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative sequence index " + n);
        }
        if (n >= this.header.getSequenceDictionary().size()) {
            return false;
        }
        SAMSequenceRecord sAMSequenceRecord = this.header.getSequence(n);
        return n2 <= sAMSequenceRecord.getSequenceLength();
    }

    @Override
    public int nextPosition(int n, int n2) {
        if (this.get(n, n2 + 1)) {
            return n2 + 1;
        }
        return -1;
    }

    @Override
    public int getMaxSequenceIndex() {
        return this.header.getSequenceDictionary().size() - 1;
    }

    @Override
    public int getMaxPosition() {
        SAMSequenceRecord sAMSequenceRecord = this.header.getSequence(this.getMaxSequenceIndex());
        return sAMSequenceRecord.getSequenceLength();
    }
}

