/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.sf.picard.PicardException;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.FormatUtil;
import net.sf.picard.util.Interval;
import net.sf.picard.util.IntervalCoordinateComparator;
import net.sf.picard.util.Log;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMTextHeaderCodec;
import net.sf.samtools.util.StringLineReader;

public class IntervalList
implements Iterable<Interval> {
    private final SAMFileHeader header;
    private final List<Interval> intervals = new ArrayList<Interval>();
    private static final Log log = Log.getInstance(IntervalList.class);

    public IntervalList(SAMFileHeader sAMFileHeader) {
        if (sAMFileHeader == null) {
            throw new IllegalArgumentException("SAMFileHeader must be supplied.");
        }
        this.header = sAMFileHeader;
    }

    public SAMFileHeader getHeader() {
        return this.header;
    }

    @Override
    public Iterator<Interval> iterator() {
        return this.intervals.iterator();
    }

    public void add(Interval interval) {
        this.intervals.add(interval);
    }

    public void sort() {
        Collections.sort(this.intervals, new IntervalCoordinateComparator(this.header));
        this.header.setSortOrder(SAMFileHeader.SortOrder.coordinate);
    }

    public void unique() {
        this.unique(true);
    }

    public void unique(boolean bl) {
        this.sort();
        List<Interval> list = this.getUniqueIntervals(bl);
        this.intervals.clear();
        this.intervals.addAll(list);
    }

    public List<Interval> getIntervals() {
        return Collections.unmodifiableList(this.intervals);
    }

    public List<Interval> getUniqueIntervals() {
        return this.getUniqueIntervals(true);
    }

    public List<Interval> getUniqueIntervals(boolean bl) {
        if (this.getHeader().getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
            this.sort();
        }
        ArrayList<Interval> arrayList = new ArrayList<Interval>();
        ListIterator<Interval> listIterator = this.intervals.listIterator();
        Interval interval = listIterator.next();
        while (listIterator.hasNext()) {
            Interval interval2 = listIterator.next();
            if (interval.intersects(interval2) || interval.abuts(interval2)) {
                String string = bl ? interval.getName() + "|" + interval2.getName() : interval.getName();
                interval = new Interval(interval.getSequence(), interval.getStart(), Math.max(interval.getEnd(), interval2.getEnd()), interval.isNegativeStrand(), string);
                continue;
            }
            arrayList.add(interval);
            interval = interval2;
        }
        if (interval != null) {
            arrayList.add(interval);
        }
        return arrayList;
    }

    public long getBaseCount() {
        return Interval.countBases(this.intervals);
    }

    public long getUniqueBaseCount() {
        return Interval.countBases(this.getUniqueIntervals());
    }

    public int size() {
        return this.intervals.size();
    }

    public static IntervalList fromFile(File file) {
        return IntervalList.fromReader(new BufferedReader(new InputStreamReader(IoUtil.openFileForReading(file)), IoUtil.STANDARD_BUFFER_SIZE));
    }

    public static IntervalList fromReader(BufferedReader bufferedReader) {
        try {
            Object object;
            StringBuilder stringBuilder = new StringBuilder(4096);
            String string = null;
            while ((string = bufferedReader.readLine()) != null && string.startsWith("@")) {
                stringBuilder.append(string).append('\n');
            }
            if (stringBuilder.length() == 0) {
                throw new IllegalStateException("Interval list file must contain header. ");
            }
            StringLineReader stringLineReader = new StringLineReader(stringBuilder.toString());
            SAMTextHeaderCodec sAMTextHeaderCodec = new SAMTextHeaderCodec();
            IntervalList intervalList = new IntervalList(sAMTextHeaderCodec.decode(stringLineReader, "BufferedReader"));
            SAMSequenceDictionary sAMSequenceDictionary = intervalList.getHeader().getSequenceDictionary();
            FormatUtil formatUtil = new FormatUtil();
            do {
                boolean bl;
                if (string.trim().length() == 0) continue;
                object = string.split("\t");
                if (((String[])object).length != 5) {
                    throw new PicardException("Invalid interval record contains " + ((String[])object).length + " fields: " + string);
                }
                String string2 = object[0];
                int n = formatUtil.parseInt(object[1]);
                int n2 = formatUtil.parseInt(object[2]);
                if (object[3].equals("-")) {
                    bl = true;
                } else if (object[3].equals("+")) {
                    bl = false;
                } else {
                    throw new IllegalArgumentException("Invalid strand field: " + object[3]);
                }
                String string3 = object[4];
                Interval interval = new Interval(string2, n, n2, bl, string3);
                if (sAMSequenceDictionary.getSequence(string2) == null) {
                    log.warn("Ignoring interval for unknown reference: " + interval);
                    continue;
                }
                intervalList.intervals.add(interval);
            } while ((string = bufferedReader.readLine()) != null);
            object = intervalList;
            return object;
        }
        catch (IOException iOException) {
            throw new PicardException("Error parsing interval list.", iOException);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {}
        }
    }

    public void write(File file) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(IoUtil.openFileForWriting(file)), IoUtil.STANDARD_BUFFER_SIZE);
            FormatUtil formatUtil = new FormatUtil();
            if (this.header != null) {
                SAMTextHeaderCodec sAMTextHeaderCodec = new SAMTextHeaderCodec();
                sAMTextHeaderCodec.encode(bufferedWriter, this.header);
            }
            for (Interval interval : this) {
                bufferedWriter.write(interval.getSequence());
                bufferedWriter.write(9);
                bufferedWriter.write(formatUtil.format(interval.getStart()));
                bufferedWriter.write(9);
                bufferedWriter.write(formatUtil.format(interval.getEnd()));
                bufferedWriter.write(9);
                bufferedWriter.write(interval.isPositiveStrand() ? 43 : 45);
                bufferedWriter.write(9);
                bufferedWriter.write(interval.getName());
                bufferedWriter.newLine();
            }
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            throw new PicardException("Error writing out interval list to file: " + file.getAbsolutePath(), iOException);
        }
    }
}

