/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.sf.picard.PicardException;
import net.sf.picard.io.IoUtil;
import net.sf.picard.sam.AbstractAlignmentMerger;
import net.sf.picard.sam.MergingSamRecordIterator;
import net.sf.picard.sam.PrimaryAlignmentSelectionStrategy;
import net.sf.picard.sam.SamFileHeaderMerger;
import net.sf.picard.sam.SamPairUtil;
import net.sf.picard.util.Log;
import net.sf.picard.util.PeekableIterator;
import net.sf.samtools.BAMRecordCodec;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMProgramRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordQueryNameComparator;
import net.sf.samtools.util.CloseableIterator;
import net.sf.samtools.util.DelegatingIterator;
import net.sf.samtools.util.SortingCollection;

public class SamAlignmentMerger
extends AbstractAlignmentMerger {
    private final Log log = Log.getInstance(SamAlignmentMerger.class);
    private final List<File> alignedSamFile;
    private final List<File> read1AlignedSamFile;
    private final List<File> read2AlignedSamFile;
    private final int maxGaps;
    private boolean forceSort = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SamAlignmentMerger(File file, File file2, File file3, SAMProgramRecord sAMProgramRecord, boolean bl, boolean bl2, boolean bl3, boolean bl4, List<File> list, int n, List<String> list2, Integer n2, Integer n3, List<File> list3, List<File> list4, List<SamPairUtil.PairOrientation> list5, SAMFileHeader.SortOrder sortOrder, PrimaryAlignmentSelectionStrategy primaryAlignmentSelectionStrategy) {
        super(file, file2, file3, bl, bl2, bl4, sAMProgramRecord, list2, n2, n3, list5, sortOrder, primaryAlignmentSelectionStrategy);
        Object object;
        if (!(list != null && list.size() != 0 || list3 != null && list3.size() != 0 && list4 != null && list4.size() != 0)) {
            throw new IllegalArgumentException("Either alignedSamFile or BOTH of read1AlignedSamFile and read2AlignedSamFile must be specified.");
        }
        if (list != null) {
            for (File iterator : list) {
                IoUtil.assertFileIsReadable(iterator);
            }
        } else {
            for (File file4 : list3) {
                IoUtil.assertFileIsReadable(file4);
            }
            for (File file5 : list4) {
                IoUtil.assertFileIsReadable(file5);
            }
        }
        this.alignedSamFile = list;
        this.read1AlignedSamFile = list3;
        this.read2AlignedSamFile = list4;
        this.maxGaps = n;
        if (sAMProgramRecord == null) {
            object = this.alignedSamFile != null && this.alignedSamFile.size() > 0 ? this.alignedSamFile.get(0) : this.read1AlignedSamFile.get(0);
            SAMFileReader sAMFileReader = new SAMFileReader((File)object);
            sAMFileReader.setValidationStringency(SAMFileReader.ValidationStringency.SILENT);
            if (sAMFileReader.getFileHeader().getProgramRecords().size() == 1) {
                this.setProgramRecord(sAMFileReader.getFileHeader().getProgramRecords().get(0));
            }
            sAMFileReader.close();
        }
        if (this.getProgramRecord() != null) {
            object = new SAMFileReader(file);
            try {
                for (SAMProgramRecord sAMProgramRecord2 : ((SAMFileReader)object).getFileHeader().getProgramRecords()) {
                    if (!sAMProgramRecord2.getId().equals(this.getProgramRecord().getId())) continue;
                    throw new PicardException("Program Record ID already in use in unmapped BAM file.");
                }
            }
            finally {
                ((SAMFileReader)object).close();
            }
        }
        this.log.info("Processing SAM file(s): " + list != null ? list : list3 + "," + list4);
    }

    @Override
    public void mergeAlignment() {
        try {
            super.mergeAlignment();
        }
        catch (IllegalStateException illegalStateException) {
            this.forceSort = true;
            this.resetRefSeqFileWalker();
            super.mergeAlignment();
        }
    }

    @Override
    protected CloseableIterator<SAMRecord> getQuerynameSortedAlignedRecords() {
        SAMFileHeader sAMFileHeader;
        CloseableIterator<SAMRecord> closeableIterator;
        ArrayList<SAMFileHeader> arrayList;
        if (this.alignedSamFile != null && this.alignedSamFile.size() > 0) {
            arrayList = new ArrayList(this.alignedSamFile.size());
            ArrayList<SAMFileReader> arrayList2 = new ArrayList<SAMFileReader>(this.alignedSamFile.size());
            for (File file : this.alignedSamFile) {
                SAMFileReader sAMFileReader = new SAMFileReader(file);
                arrayList.add(sAMFileReader.getFileHeader());
                arrayList2.add(sAMFileReader);
            }
            SamFileHeaderMerger samFileHeaderMerger = new SamFileHeaderMerger(SAMFileHeader.SortOrder.coordinate, arrayList, false);
            closeableIterator = new MergingSamRecordIterator(samFileHeaderMerger, arrayList2, true);
            sAMFileHeader = samFileHeaderMerger.getMergedHeader();
        } else {
            closeableIterator = new SeparateEndAlignmentIterator(this.read1AlignedSamFile, this.read2AlignedSamFile);
            sAMFileHeader = ((SeparateEndAlignmentIterator)closeableIterator).getHeader();
        }
        if (!this.forceSort) {
            return closeableIterator;
        }
        arrayList = SortingCollection.newInstance(SAMRecord.class, new BAMRecordCodec(sAMFileHeader), new SAMRecordQueryNameComparator(), 500000);
        int n = 0;
        while (closeableIterator.hasNext()) {
            ((SortingCollection)((Object)arrayList)).add(closeableIterator.next());
            if (++n <= 0 || n % 1000000 != 0) continue;
            this.log.info("Read " + n + " records from alignment SAM/BAM.");
        }
        this.log.info("Finished reading " + n + " total records from alignment SAM/BAM.");
        closeableIterator.close();
        return new DelegatingIterator<SAMRecord>(((SortingCollection)((Object)arrayList)).iterator()){

            @Override
            public void close() {
                super.close();
                arrayList.cleanup();
            }
        };
    }

    @Override
    protected boolean ignoreAlignment(SAMRecord sAMRecord) {
        if (this.maxGaps == -1) {
            return false;
        }
        int n = 0;
        for (CigarElement cigarElement : sAMRecord.getCigar().getCigarElements()) {
            if (cigarElement.getOperator() != CigarOperator.I && cigarElement.getOperator() != CigarOperator.D) continue;
            ++n;
        }
        return n > this.maxGaps;
    }

    public boolean getForceSort() {
        return this.forceSort;
    }

    private class SeparateEndAlignmentIterator
    implements CloseableIterator<SAMRecord> {
        private final PeekableIterator<SAMRecord> read1Iterator;
        private final PeekableIterator<SAMRecord> read2Iterator;
        private final SAMFileHeader header;

        public SeparateEndAlignmentIterator(List<File> list, List<File> list2) {
            SAMFileReader sAMFileReader;
            ArrayList<SAMFileHeader> arrayList = new ArrayList<SAMFileHeader>();
            ArrayList<SAMFileReader> arrayList2 = new ArrayList<SAMFileReader>(list.size());
            ArrayList<SAMFileReader> arrayList3 = new ArrayList<SAMFileReader>(list2.size());
            for (File file : list) {
                sAMFileReader = new SAMFileReader(file);
                arrayList.add(sAMFileReader.getFileHeader());
                arrayList2.add(sAMFileReader);
            }
            for (File file : list2) {
                sAMFileReader = new SAMFileReader(file);
                arrayList.add(sAMFileReader.getFileHeader());
                arrayList3.add(sAMFileReader);
            }
            SamFileHeaderMerger samFileHeaderMerger = new SamFileHeaderMerger(SAMFileHeader.SortOrder.coordinate, arrayList, false);
            this.read1Iterator = new PeekableIterator<SAMRecord>(new SuffixTrimingSamRecordIterator(new MergingSamRecordIterator(samFileHeaderMerger, arrayList2, true), "/1"));
            this.read2Iterator = new PeekableIterator<SAMRecord>(new SuffixTrimingSamRecordIterator(new MergingSamRecordIterator(samFileHeaderMerger, arrayList3, true), "/2"));
            this.header = samFileHeaderMerger.getMergedHeader();
        }

        @Override
        public void close() {
            this.read1Iterator.close();
            this.read2Iterator.close();
        }

        @Override
        public boolean hasNext() {
            return this.read1Iterator.hasNext() || this.read2Iterator.hasNext();
        }

        @Override
        public SAMRecord next() {
            if (this.read1Iterator.hasNext()) {
                if (this.read2Iterator.hasNext()) {
                    return this.read1Iterator.peek().getReadName().compareTo(this.read2Iterator.peek().getReadName()) <= 0 ? this.setPairFlags(this.read1Iterator.next(), true) : this.setPairFlags(this.read2Iterator.next(), false);
                }
                return this.setPairFlags(this.read1Iterator.next(), true);
            }
            return this.setPairFlags(this.read2Iterator.next(), false);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() not supported");
        }

        public SAMFileHeader getHeader() {
            return this.header;
        }

        private SAMRecord setPairFlags(SAMRecord sAMRecord, boolean bl) {
            sAMRecord.setReadPairedFlag(true);
            sAMRecord.setFirstOfPairFlag(bl);
            sAMRecord.setSecondOfPairFlag(!bl);
            return sAMRecord;
        }
    }

    private class SuffixTrimingSamRecordIterator
    implements CloseableIterator<SAMRecord> {
        private final CloseableIterator<SAMRecord> underlyingIterator;
        private final String suffixToTrim;

        private SuffixTrimingSamRecordIterator(CloseableIterator<SAMRecord> closeableIterator, String string) {
            this.underlyingIterator = closeableIterator;
            this.suffixToTrim = string;
        }

        @Override
        public void close() {
            this.underlyingIterator.close();
        }

        @Override
        public boolean hasNext() {
            return this.underlyingIterator.hasNext();
        }

        @Override
        public SAMRecord next() {
            SAMRecord sAMRecord = (SAMRecord)this.underlyingIterator.next();
            String string = sAMRecord.getReadName();
            if (string.endsWith(this.suffixToTrim)) {
                sAMRecord.setReadName(string.substring(0, string.length() - this.suffixToTrim.length()));
            }
            return sAMRecord;
        }

        @Override
        public void remove() {
            this.underlyingIterator.remove();
        }
    }
}

