/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import net.sf.picard.metrics.MetricBase;
import net.sf.picard.util.Histogram;

public class DuplicationMetrics
extends MetricBase {
    public String LIBRARY;
    public long UNPAIRED_READS_EXAMINED;
    public long READ_PAIRS_EXAMINED;
    public long UNMAPPED_READS;
    public long UNPAIRED_READ_DUPLICATES;
    public long READ_PAIR_DUPLICATES;
    public long READ_PAIR_OPTICAL_DUPLICATES;
    public Double PERCENT_DUPLICATION;
    public Long ESTIMATED_LIBRARY_SIZE;

    public void calculateDerivedMetrics() {
        this.ESTIMATED_LIBRARY_SIZE = DuplicationMetrics.estimateLibrarySize(this.READ_PAIRS_EXAMINED - this.READ_PAIR_OPTICAL_DUPLICATES, this.READ_PAIRS_EXAMINED - this.READ_PAIR_DUPLICATES);
        this.PERCENT_DUPLICATION = (double)(this.UNPAIRED_READ_DUPLICATES + this.READ_PAIR_DUPLICATES * 2L) / (double)(this.UNPAIRED_READS_EXAMINED + this.READ_PAIRS_EXAMINED * 2L);
    }

    public static Long estimateLibrarySize(long l, long l2) {
        long l3 = l - l2;
        if (l > 0L && l3 > 0L) {
            double d;
            double d2;
            long l4 = l;
            long l5 = l2;
            double d3 = 1.0;
            double d4 = 100.0;
            if (l5 >= l4 || DuplicationMetrics.f(d3 * (double)l5, l5, l4) < 0.0) {
                throw new IllegalStateException("Invalid values for pairs and unique pairs: " + l4 + ", " + l5);
            }
            while (DuplicationMetrics.f(d4 * (double)l5, l5, l4) >= 0.0) {
                d4 *= 10.0;
            }
            for (int i = 0; i < 40 && (d2 = DuplicationMetrics.f((d = (d3 + d4) / 2.0) * (double)l5, l5, l4)) != 0.0; ++i) {
                if (d2 > 0.0) {
                    d3 = d;
                    continue;
                }
                if (!(d2 < 0.0)) continue;
                d4 = d;
            }
            return (long)((double)l5 * (d3 + d4) / 2.0);
        }
        return null;
    }

    private static double f(double d, double d2, double d3) {
        return d2 / d - 1.0 + Math.exp(-d3 / d);
    }

    public static double estimateRoi(long l, double d, long l2, long l3) {
        return (double)l * (1.0 - Math.exp(-(d * (double)l2) / (double)l)) / (double)l3;
    }

    public Histogram<Double> calculateRoiHistogram() {
        if (this.ESTIMATED_LIBRARY_SIZE == null) {
            try {
                this.calculateDerivedMetrics();
                if (this.ESTIMATED_LIBRARY_SIZE == null) {
                    return null;
                }
            }
            catch (IllegalStateException illegalStateException) {
                return null;
            }
        }
        long l = this.READ_PAIRS_EXAMINED - this.READ_PAIR_DUPLICATES;
        Histogram<Double> histogram = new Histogram<Double>();
        for (double d = 1.0; d <= 100.0; d += 1.0) {
            histogram.increment(d, DuplicationMetrics.estimateRoi(this.ESTIMATED_LIBRARY_SIZE, d, this.READ_PAIRS_EXAMINED, l));
        }
        return histogram;
    }

    public static void main(String[] stringArray) {
        DuplicationMetrics duplicationMetrics = new DuplicationMetrics();
        duplicationMetrics.READ_PAIRS_EXAMINED = Integer.parseInt(stringArray[0]);
        duplicationMetrics.READ_PAIR_DUPLICATES = Integer.parseInt(stringArray[1]);
        duplicationMetrics.calculateDerivedMetrics();
        System.out.println("Percent Duplication: " + duplicationMetrics.PERCENT_DUPLICATION);
        System.out.println("Est. Library Size  : " + duplicationMetrics.ESTIMATED_LIBRARY_SIZE);
        System.out.println();
        System.out.println("X Seq\tX Unique");
        for (Histogram.Bin bin : duplicationMetrics.calculateRoiHistogram().values()) {
            System.out.println(bin.getId() + "\t" + bin.getValue());
        }
    }
}

