/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.Log;
import net.sf.samtools.BAMIndexer;
import net.sf.samtools.SAMException;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.CloserUtil;

public class BuildBamIndex
extends CommandLineProgram {
    private static final Log log = Log.getInstance(BuildBamIndex.class);
    @Usage
    public String USAGE = this.getStandardUsagePreamble() + "Generates a BAM index (.bai) file.";
    @Option(shortName="I", doc="A BAM file or URL to process. Must be sorted in coordinate order.")
    public String INPUT;
    URL inputUrl = null;
    File inputFile = null;
    @Option(shortName="O", doc="The BAM index file. Defaults to x.bai if INPUT is x.bam, otherwise INPUT.bai.\nIf INPUT is a URL and OUTPUT is unspecified, defaults to a file in the current directory.", optional=true)
    public File OUTPUT;

    public static void main(String[] stringArray) {
        System.exit(new BuildBamIndex().instanceMain(stringArray));
    }

    @Override
    protected int doWork() {
        Object object;
        try {
            this.inputUrl = new URL(this.INPUT);
        }
        catch (MalformedURLException malformedURLException) {
            this.inputFile = new File(this.INPUT);
        }
        if (this.OUTPUT == null) {
            if (this.inputUrl != null) {
                String string = this.inputUrl.getPath();
                int n = string.lastIndexOf("/");
                object = string.substring(n + 1, string.length());
            } else {
                object = this.inputFile.getAbsolutePath();
            }
            if (((String)object).endsWith(".bam")) {
                int n = ((String)object).lastIndexOf(".");
                this.OUTPUT = new File(((String)object).substring(0, n) + ".bai");
            } else {
                this.OUTPUT = new File((String)object + ".bai");
            }
        }
        IoUtil.assertFileIsWritable(this.OUTPUT);
        if (this.inputUrl != null) {
            object = new SAMFileReader(this.inputUrl, null, false);
        } else {
            IoUtil.assertFileIsReadable(this.inputFile);
            object = new SAMFileReader(this.inputFile);
        }
        if (!((SAMFileReader)object).isBinary()) {
            throw new SAMException("Input file must be bam file, not sam file.");
        }
        if (!((SAMFileReader)object).getFileHeader().getSortOrder().equals((Object)SAMFileHeader.SortOrder.coordinate)) {
            throw new SAMException("Input bam file must be sorted by coordinates");
        }
        BuildBamIndex.createIndex((SAMFileReader)object, this.OUTPUT);
        log.info("Successfully wrote bam index file " + this.OUTPUT);
        CloserUtil.close(object);
        return 0;
    }

    public static void createIndex(SAMFileReader sAMFileReader, File file) {
        BAMIndexer bAMIndexer = new BAMIndexer(file, sAMFileReader.getFileHeader());
        sAMFileReader.enableFileSource(true);
        int n = 0;
        for (SAMRecord sAMRecord : sAMFileReader) {
            if (++n % 1000000 == 0) {
                log.info(n + " reads processed ...");
            }
            bAMIndexer.processAlignment(sAMRecord);
        }
        bAMIndexer.finish();
    }
}

