/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.reference;

import java.io.File;
import net.sf.picard.PicardException;
import net.sf.picard.io.FastLineReader;
import net.sf.picard.io.IoUtil;
import net.sf.picard.reference.AbstractFastaSequenceFile;
import net.sf.picard.reference.ReferenceSequence;
import net.sf.samtools.SAMSequenceRecord;
import net.sf.samtools.util.StringUtil;

public class FastaSequenceFile
extends AbstractFastaSequenceFile {
    private final boolean truncateNamesAtWhitespace;
    private FastLineReader in;
    private int sequenceIndex = -1;
    private static final int BUFFER_SIZE = 5000;
    private final byte[] basesBuffer = new byte[5000];

    public FastaSequenceFile(File file, boolean bl) {
        super(file);
        this.truncateNamesAtWhitespace = bl;
        this.in = new FastLineReader(IoUtil.openFileForReading(file));
    }

    public void close() {
        this.in.close();
    }

    @Override
    public ReferenceSequence nextSequence() {
        ++this.sequenceIndex;
        String string = this.readSequenceName();
        if (string == null) {
            this.close();
            return null;
        }
        int n = this.sequenceDictionary == null ? -1 : this.sequenceDictionary.getSequence(this.sequenceIndex).getSequenceLength();
        byte[] byArray = this.readSequence(n);
        return new ReferenceSequence(string, this.sequenceIndex, byArray);
    }

    @Override
    public void reset() {
        this.sequenceIndex = -1;
        this.in.close();
        this.in = new FastLineReader(IoUtil.openFileForReading(this.file));
    }

    private String readSequenceName() {
        this.in.skipNewlines();
        if (this.in.eof()) {
            return null;
        }
        byte by = this.in.getByte();
        if (by != 62) {
            throw new PicardException("Format exception reading FASTA " + this.file + ".  Expected > but saw chr(" + by + ") at start of sequence with index " + this.sequenceIndex);
        }
        byte[] byArray = new byte[4096];
        int n = 0;
        while (!this.in.eof()) {
            if ((n += this.in.readToEndOfOutputBufferOrEoln(byArray, n)) == byArray.length && !this.in.atEoln()) {
                throw new PicardException("Sequence name too long in FASTA " + this.file);
            }
            if (!this.in.atEoln()) continue;
        }
        if (n == 0) {
            throw new PicardException("Missing sequence name in FASTA " + this.file);
        }
        String string = StringUtil.bytesToString(byArray, 0, n).trim();
        if (this.truncateNamesAtWhitespace) {
            string = SAMSequenceRecord.truncateSequenceName(string);
        }
        return string;
    }

    private byte[] readSequence(int n) {
        byte[] byArray = n == -1 ? this.basesBuffer : new byte[n];
        int n2 = 0;
        while (!this.in.eof()) {
            boolean bl = this.in.skipNewlines();
            if (this.in.eof() || bl && this.in.peekByte() == 62) break;
            n2 += this.in.readToEndOfOutputBufferOrEoln(byArray, n2);
            while (n2 > 0 && Character.isWhitespace(StringUtil.byteToChar(byArray[n2 - 1]))) {
                --n2;
            }
            if (n2 == n) break;
            if (n2 != byArray.length) continue;
            byte[] byArray2 = new byte[byArray.length * 2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            byArray = byArray2;
        }
        if (n2 != byArray.length || byArray == this.basesBuffer) {
            byte[] byArray3 = new byte[n2];
            System.arraycopy(byArray, 0, byArray3, 0, n2);
            byArray = byArray3;
        }
        return byArray;
    }
}

