/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.IlluminaFileMap;
import net.sf.picard.illumina.parser.IlluminaTextIterator;
import net.sf.picard.illumina.parser.OutputMapping;
import net.sf.picard.illumina.parser.QseqReadData;
import net.sf.picard.illumina.parser.Range;
import net.sf.picard.util.BasicInputParser;
import net.sf.picard.util.FormatUtil;
import net.sf.picard.util.SolexaQualityConverter;

class QseqReadParser {
    public static final int MACHINE_COLUMN = 0;
    public static final int RUN__COLUMN = 1;
    public static final int LANE_COLUMN = 2;
    public static final int TILE_COLUMN = 3;
    public static final int X_COLUMN = 4;
    public static final int Y_COLUMN = 5;
    public static final int PF_COLUMN = 10;
    public static final int BASES_COLUMN = 8;
    public static final int QUALS_COLUMN = 9;
    private final IlluminaTextIterator textParser;
    private final FormatUtil formatter;
    private final Range[] srcRanges;
    private final OutputMapping.TwoDIndex[] dstStarts;
    private final int[] copyLengths;
    protected final int readLength;
    private static final SolexaQualityConverter qualConverter = SolexaQualityConverter.getSingleton();

    public QseqReadParser(int n, IlluminaFileMap illuminaFileMap, Range[] rangeArray, OutputMapping.TwoDIndex[] twoDIndexArray, OutputMapping outputMapping) {
        this.textParser = new IlluminaTextIterator(n, illuminaFileMap);
        this.formatter = new FormatUtil();
        this.readLength = QseqReadParser.getReadLength((File)illuminaFileMap.firstEntry().getValue());
        this.srcRanges = rangeArray;
        this.dstStarts = twoDIndexArray;
        this.copyLengths = new int[rangeArray.length];
        for (int i = 0; i < this.copyLengths.length; ++i) {
            this.copyLengths[i] = rangeArray[i].length;
        }
    }

    public void seekToTile(int n) {
        this.textParser.seekToTile(n);
    }

    public boolean hasNext() {
        return this.textParser.hasNext();
    }

    public void next(QseqReadData qseqReadData) {
        String[] stringArray = this.textParser.next();
        int n = this.formatter.parseInt(stringArray[2]);
        this.textParser.validateLane(n);
        int n2 = this.formatter.parseInt(stringArray[3]);
        int n3 = this.formatter.parseInt(stringArray[4]);
        int n4 = this.formatter.parseInt(stringArray[5]);
        boolean bl = this.formatter.parseInt(stringArray[10]) == 1;
        String string = stringArray[8];
        String string2 = stringArray[9];
        if (string.length() != string2.length()) {
            throw new PicardException("Length of bases and quals don't match in " + this.textParser.getCurrentFilename());
        }
        qseqReadData.setOrCheckLane(n);
        qseqReadData.setOrCheckTile(n2);
        qseqReadData.setOrCheckXCoordinate(n3);
        qseqReadData.setOrCheckYCoordinate(n4);
        qseqReadData.setOrCheckPf(bl);
        QseqReadParser.stringToBytes(string, this.srcRanges, this.dstStarts, qseqReadData.getBases());
        QseqReadParser.stringToQuals(string2, this.srcRanges, this.dstStarts, this.copyLengths, qseqReadData.getQualities());
    }

    private static void stringToBytes(String string, Range[] rangeArray, OutputMapping.TwoDIndex[] twoDIndexArray, byte[][] byArray) {
        for (int i = 0; i < rangeArray.length; ++i) {
            string.getBytes(rangeArray[i].start, rangeArray[i].end + 1, byArray[twoDIndexArray[i].majorIndex], twoDIndexArray[i].minorIndex);
        }
    }

    private static void stringToQuals(String string, Range[] rangeArray, OutputMapping.TwoDIndex[] twoDIndexArray, int[] nArray, byte[][] byArray) {
        QseqReadParser.stringToBytes(string, rangeArray, twoDIndexArray, byArray);
        for (int i = 0; i < twoDIndexArray.length; ++i) {
            qualConverter.convertSolexa_1_3_QualityCharsToPhredBinary(twoDIndexArray[i].minorIndex, nArray[i], byArray[twoDIndexArray[i].majorIndex]);
        }
    }

    public static int getReadLength(File file) {
        BasicInputParser basicInputParser = new BasicInputParser(true, file);
        if (!basicInputParser.hasNext()) {
            throw new PicardException("Unexpected empty qseq file: " + file);
        }
        String[] stringArray = (String[])basicInputParser.next();
        return stringArray[8].length();
    }
}

