/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.IlluminaDataType;
import net.sf.picard.illumina.parser.IlluminaFileMap;
import net.sf.picard.illumina.parser.IlluminaParser;
import net.sf.picard.illumina.parser.OutputMapping;
import net.sf.picard.illumina.parser.QseqReadData;
import net.sf.picard.illumina.parser.QseqReadParser;
import net.sf.picard.illumina.parser.Range;
import net.sf.samtools.util.CollectionUtil;
import net.sf.samtools.util.StringUtil;

class QseqParser
implements IlluminaParser<QseqReadData> {
    private final int[] outputLengths;
    private final QseqReadParser[] parsers;
    private final List<IlluminaFileMap> tileMapByReadNumber;
    private QseqReadData nextData;
    public static final Set<IlluminaDataType> SUPPORTED_TYPES = Collections.unmodifiableSet(CollectionUtil.makeSet(IlluminaDataType.Position, IlluminaDataType.BaseCalls, IlluminaDataType.QualityScores, IlluminaDataType.PF));

    public QseqParser(int n, List<IlluminaFileMap> list, OutputMapping outputMapping) {
        this.outputLengths = outputMapping.getOutputReadLengths();
        this.tileMapByReadNumber = list;
        List<QseqReadParser> list2 = this.makeReadParserList(n, outputMapping);
        this.parsers = list2.toArray(new QseqReadParser[list2.size()]);
        this.retrieveNext();
    }

    public List<QseqReadParser> makeReadParserList(int n, OutputMapping outputMapping) {
        int[] nArray = new int[this.tileMapByReadNumber.size()];
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = QseqReadParser.getReadLength((File)this.tileMapByReadNumber.get(i).firstEntry().getValue());
            n2 += nArray[i];
        }
        if (n2 < outputMapping.getTotalOutputCycles()) {
            throw new PicardException("Expected output cycles (" + outputMapping.getTotalOutputCycles() + ") is greater than the number of cycles in Qseq files (" + n2 + ")");
        }
        ArrayList<QseqReadParser> arrayList = new ArrayList<QseqReadParser>(nArray.length);
        List<Range> list = QseqParser.splitOutputRangesOnQseqBoundaries(nArray, outputMapping);
        List<List<Range>> list2 = QseqParser.outputRangesToInputRanges(nArray, list);
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>(list2.size());
        for (List<Range> list3 : list2) {
            arrayList2.add(list3.size());
        }
        List<List<OutputMapping.TwoDIndex>> list4 = QseqParser.outputRangesTo2DTargetsPerRead(arrayList2, list, outputMapping);
        for (int i = 0; i < list2.size(); ++i) {
            if ((Integer)arrayList2.get(i) <= 0) continue;
            List<Range> list5 = list2.get(i);
            List list6 = (List)list4.get(i);
            arrayList.add(new QseqReadParser(n, this.tileMapByReadNumber.get(i), list5.toArray(new Range[list5.size()]), list6.toArray(new OutputMapping.TwoDIndex[list6.size()]), outputMapping));
        }
        if (arrayList.size() == 0) {
            throw new PicardException("0 Qseq \"ends\" were found to parse!");
        }
        return arrayList;
    }

    public static List<List<Range>> outputRangesToInputRanges(int[] nArray, List<Range> list) {
        int n;
        ArrayList<Range> arrayList = new ArrayList<Range>(list);
        ArrayList<List<Range>> arrayList2 = new ArrayList<List<Range>>(nArray.length);
        for (n = 0; n < nArray.length; ++n) {
            arrayList2.add(new LinkedList());
        }
        n = 0;
        int n2 = 0;
        int n3 = nArray[n2] - 1;
        List list2 = (List)arrayList2.get(n);
        while (!arrayList.isEmpty()) {
            int n4;
            Range range = (Range)arrayList.remove(0);
            while (range.start > n3) {
                n2 = n3 + 1;
                n3 = n2 + nArray[++n] - 1;
                list2 = (List)arrayList2.get(n);
            }
            if (n3 < range.end) {
                arrayList.add(0, new Range(n3 + 1, range.end));
                n4 = n3;
            } else {
                n4 = range.end;
            }
            list2.add(new Range(range.start - n2, n4 - n2));
        }
        return arrayList2;
    }

    public static List<List<OutputMapping.TwoDIndex>> outputRangesTo2DTargetsPerRead(List<Integer> list, List<Range> list2, OutputMapping outputMapping) {
        int n;
        ArrayList<List<OutputMapping.TwoDIndex>> arrayList = new ArrayList<List<OutputMapping.TwoDIndex>>(list.size());
        for (n = 0; n < list.size(); ++n) {
            arrayList.add(new ArrayList(list.get(n)));
        }
        n = 0;
        int n2 = 0;
        int n3 = list.get(n2);
        List list3 = (List)arrayList.get(n2);
        for (Range range : list2) {
            while (n >= n3) {
                n = 0;
                n3 = list.get(++n2);
                list3 = (List)arrayList.get(n2);
            }
            list3.add(outputMapping.getOutputIndexForCycle(range.start + 1));
            ++n;
        }
        return arrayList;
    }

    public static List<Range> splitOutputRangesOnQseqBoundaries(int[] nArray, OutputMapping outputMapping) {
        LinkedList<Range> linkedList = new LinkedList<Range>(Arrays.asList(outputMapping.getCycleIndexRanges()));
        LinkedList<Range> linkedList2 = new LinkedList<Range>();
        int n = 0;
        int n2 = 0;
        while (linkedList.size() > 0) {
            Range range = (Range)linkedList.remove(0);
            int n3 = n2 + nArray[n] - 1;
            if (range.start <= n3) {
                if (range.end > n3) {
                    linkedList2.add(new Range(range.start, n3));
                    linkedList.add(0, new Range(n3 + 1, range.end));
                    continue;
                }
                linkedList2.add(range);
                continue;
            }
            linkedList.add(0, range);
            n2 = n3 + 1;
            ++n;
        }
        return linkedList2;
    }

    @Override
    public void verifyData(List<Integer> list, int[] nArray) {
        Integer n = null;
        int n2 = 1;
        for (IlluminaFileMap illuminaFileMap : this.tileMapByReadNumber) {
            Serializable serializable;
            if (list != null && !illuminaFileMap.keySet().containsAll(list)) {
                serializable = new TreeSet<Integer>(list);
                serializable.removeAll(illuminaFileMap.keySet());
                throw new PicardException("IlluminaFileMap for \"end\" number " + n2 + " is missing tiles: " + StringUtil.join(",", new ArrayList<Integer>((Collection<Integer>)((Object)serializable))));
            }
            if (n == null) {
                n = illuminaFileMap.size();
            } else if (n.intValue() != illuminaFileMap.size()) {
                throw new PicardException("Qseq \"end\" files do not have the same number of tiles expected(" + n + ") found(" + illuminaFileMap.size() + ") on end (" + n2 + ")");
            }
            serializable = null;
            for (Map.Entry entry : illuminaFileMap.entrySet()) {
                int n3 = QseqReadParser.getReadLength((File)entry.getValue());
                if (serializable == null) {
                    serializable = n3;
                    continue;
                }
                if ((Integer)serializable == n3) continue;
                throw new PicardException("Qseq \"end\" (" + n2 + ") has tiles with different numbers of bases per read.  Found on Tile(" + entry.getKey() + ") File(" + ((File)entry.getValue()).getAbsolutePath() + ")");
            }
            ++n2;
        }
    }

    @Override
    public void seekToTile(int n) {
        for (QseqReadParser qseqReadParser : this.parsers) {
            qseqReadParser.seekToTile(n);
        }
        this.retrieveNext();
    }

    @Override
    public QseqReadData next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        QseqReadData qseqReadData = this.nextData;
        this.retrieveNext();
        return qseqReadData;
    }

    private void retrieveNext() {
        if (this.parsers[0].hasNext()) {
            this.nextData = new QseqReadData(this.outputLengths);
            for (QseqReadParser qseqReadParser : this.parsers) {
                qseqReadParser.next(this.nextData);
            }
        } else {
            this.nextData = null;
        }
    }

    @Override
    public int getTileOfNextCluster() {
        return this.nextData.getTile();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove is not supported by " + QseqParser.class.getName());
    }

    @Override
    public boolean hasNext() {
        return this.nextData != null;
    }

    @Override
    public Set<IlluminaDataType> supportedTypes() {
        return SUPPORTED_TYPES;
    }
}

