/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.List;
import java.util.Map;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.ClusterIntensityFileReader;
import net.sf.picard.illumina.parser.CycleFilesIterator;
import net.sf.picard.illumina.parser.CycleIlluminaFileMap;
import net.sf.picard.illumina.parser.FourChannelIntensityData;
import net.sf.picard.illumina.parser.IlluminaData;
import net.sf.picard.illumina.parser.IntensityChannel;
import net.sf.picard.illumina.parser.OutputMapping;
import net.sf.picard.illumina.parser.PerTilePerCycleParser;

abstract class IlluminaIntensityParser<T extends IlluminaData>
extends PerTilePerCycleParser<T> {
    public IlluminaIntensityParser(File file, int n, CycleIlluminaFileMap cycleIlluminaFileMap, OutputMapping outputMapping) {
        super(file, n, cycleIlluminaFileMap, outputMapping);
        this.initialize();
    }

    protected abstract void addIntensityToIlluminaData(T var1, OutputMapping.TwoDIndex var2, IntensityChannel var3, short var4);

    protected abstract T intensityToIlluminaData(FourChannelIntensityData[] var1);

    @Override
    protected T makeData(int[] nArray) {
        FourChannelIntensityData[] fourChannelIntensityDataArray = new FourChannelIntensityData[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            fourChannelIntensityDataArray[i] = new FourChannelIntensityData(nArray[i]);
        }
        return this.intensityToIlluminaData(fourChannelIntensityDataArray);
    }

    @Override
    protected PerTilePerCycleParser.CycleFileParser<T> makeCycleFileParser(File file, int n) {
        return new IntensityFileParser(file, n);
    }

    @Override
    public void verifyData(List<Integer> list, int[] nArray) {
        super.verifyData(list, nArray);
        Integer n = null;
        for (Map.Entry entry : this.tilesToCycleFiles.entrySet()) {
            Long l = null;
            Integer n2 = null;
            for (File file : (CycleFilesIterator)entry.getValue()) {
                ClusterIntensityFileReader.ClusterIntensityFileHeader clusterIntensityFileHeader = ClusterIntensityFileReader.readHeaders(file);
                if (l == null) {
                    l = file.length();
                    n2 = clusterIntensityFileHeader.numClusters;
                    n = clusterIntensityFileHeader.elementSize;
                    continue;
                }
                if (l.longValue() != file.length()) {
                    throw new PicardException("Intensity cycle files for tile(" + entry.getValue() + ") were not of the same size, offending file(" + file.getAbsolutePath() + ")");
                }
                if (n2 != clusterIntensityFileHeader.numClusters) {
                    throw new PicardException("Intensity cycle files for tile(" + entry.getValue() + ") did not have the same number of clusters(" + file.getAbsolutePath() + ")");
                }
                if (n != clusterIntensityFileHeader.elementSize) {
                    throw new PicardException("Intensity cycle files for tile(" + entry.getValue() + ") did not have the same element sizes(" + file.getAbsolutePath() + ")");
                }
                if (clusterIntensityFileHeader.numCycles == 1) continue;
                throw new PicardException("Intensity cycle file for tile(" + entry.getValue() + ") had more than one cycle per file num cycles found(" + clusterIntensityFileHeader.numCycles + ")");
            }
        }
    }

    protected class IntensityFileParser
    implements PerTilePerCycleParser.CycleFileParser<T> {
        private final ClusterIntensityFileReader reader;
        private final int cycle;
        private int cluster;
        private final OutputMapping.TwoDIndex index;

        public IntensityFileParser(File file, int n) {
            this.reader = new ClusterIntensityFileReader(file);
            this.cluster = 0;
            this.index = IlluminaIntensityParser.this.outputMapping.getOutputIndexForCycle(n);
            this.cycle = n;
        }

        @Override
        public void close() {
        }

        @Override
        public void next(T t) {
            for (IntensityChannel intensityChannel : IntensityChannel.values()) {
                IlluminaIntensityParser.this.addIntensityToIlluminaData(t, this.index, intensityChannel, this.reader.getValue(this.cluster, intensityChannel, this.cycle));
            }
            ++this.cluster;
        }

        @Override
        public boolean hasNext() {
            return this.cluster < this.reader.getNumClusters();
        }
    }
}

