/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.fastq.BasicFastqWriter;
import net.sf.picard.fastq.Casava18ReadNameEncoder;
import net.sf.picard.fastq.FastqReader;
import net.sf.picard.fastq.FastqRecord;
import net.sf.picard.fastq.FastqWriter;
import net.sf.picard.fastq.FastqWriterFactory;
import net.sf.picard.fastq.IlluminaReadNameEncoder;
import net.sf.picard.fastq.ReadNameEncoder;
import net.sf.picard.illumina.IlluminaBasecallsConverter;
import net.sf.picard.illumina.parser.ClusterData;
import net.sf.picard.illumina.parser.ReadData;
import net.sf.picard.illumina.parser.ReadStructure;
import net.sf.picard.illumina.parser.readers.BclQualityEvaluationStrategy;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.IlluminaUtil;
import net.sf.picard.util.Log;
import net.sf.picard.util.TabbedTextFileWithHeaderParser;
import net.sf.samtools.SAMRecordQueryNameComparator;
import net.sf.samtools.SAMUtils;
import net.sf.samtools.util.CollectionUtil;
import net.sf.samtools.util.SortingCollection;
import net.sf.samtools.util.StringUtil;

public class IlluminaBasecallsToFastq
extends CommandLineProgram {
    @Usage
    public String USAGE = this.getStandardUsagePreamble() + "Generate fastq file(s) from data in an Illumina basecalls output directory.\n" + "Separate fastq file(s) are created for each template read, and for each barcode read, in the basecalls.\n" + "Template fastqs have extensions like .<number>.fastq, where <number> is the number of the template read,\n" + "starting with 1.  Barcode fastqs have extensions like .barcode_<number>.fastq, where <number> is the number\n" + "of the barcode read, starting with 1.";
    @Option(doc="The basecalls directory. ", shortName="B")
    public File BASECALLS_DIR;
    @Option(doc="Lane number. ", shortName="L")
    public Integer LANE;
    @Option(doc="The prefix for output fastqs.  Extensions as described above are appended.  Use this option for a non-barcoded run, or for a barcoded run in which it is not desired to demultiplex reads into separate files by barcode.", shortName="O", mutex={"MULTIPLEX_PARAMS"})
    public File OUTPUT_PREFIX;
    @Option(doc="The barcode of the run.  Prefixed to read names.", optional=false)
    public String RUN_BARCODE;
    @Option(doc="The name of the machine on which the run was sequenced; required if emitting Casava1.8-style read name headers", optional=true)
    public String MACHINE_NAME;
    @Option(doc="The barcode of the flowcell that was sequenced; required if emitting Casava1.8-style read name headers", optional=true)
    public String FLOWCELL_BARCODE;
    @Option(doc="A description of the logical structure of clusters in an Illumina Run, i.e. a description of the structure IlluminaBasecallsToSam assumes the  data to be in. It should consist of integer/character pairs describing the number of cycles and the type of those cycles (B for Barcode, T for Template, and S for skip).  E.g. If the input data consists of 80 base clusters and we provide a read structure of \"36T8B8S28T\" then, before being converted to SAM records those bases will be split into 4 reads where read one consists of 36 cycles of template, read two consists of 8 cycles of barcode, read three will be an 8 base read of skipped cycles and read four is another 28 cycle template read.  The read consisting of skipped cycles would NOT be included in output SAM/BAM file read groups.", shortName="RS")
    public String READ_STRUCTURE;
    @Option(doc="Tab-separated file for creating all output fastqs demultiplexed by barcode for a lane with single IlluminaBasecallsToFastq invocation.  The columns are OUTPUT_PREFIX, and BARCODE_1, BARCODE_2 ... BARCODE_X where X = number of barcodes per cluster (optional).  Row with BARCODE_1 set to 'N' is used to specify an output_prefix for no barcode match.", mutex={"OUTPUT_PREFIX"})
    public File MULTIPLEX_PARAMS;
    @Option(doc="Which adapters to look for in the read.")
    public List<IlluminaUtil.IlluminaAdapterPair> ADAPTERS_TO_CHECK = new ArrayList<IlluminaUtil.IlluminaAdapterPair>(Arrays.asList(IlluminaUtil.IlluminaAdapterPair.INDEXED, IlluminaUtil.IlluminaAdapterPair.DUAL_INDEXED, IlluminaUtil.IlluminaAdapterPair.NEXTERA_V2, IlluminaUtil.IlluminaAdapterPair.FLUIDIGM));
    @Option(doc="The number of threads to run in parallel. If NUM_PROCESSORS = 0, number of cores is automatically set to the number of cores available on the machine. If NUM_PROCESSORS < 0, then the number of cores used will be the number available on the machine less NUM_PROCESSORS.")
    public Integer NUM_PROCESSORS = 0;
    @Option(doc="If set, this is the first tile to be processed (used for debugging).  Note that tiles are not processed in numerical order.", optional=true)
    public Integer FIRST_TILE;
    @Option(doc="If set, process no more than this many tiles (used for debugging).", optional=true)
    public Integer TILE_LIMIT;
    @Option(doc="Apply EAMSS filtering to identify inappropriately quality scored bases towards the ends of reads and convert their quality scores to Q2.")
    public boolean APPLY_EAMSS_FILTER = true;
    @Option(doc="If true, call System.gc() periodically.  This is useful in cases in which the -Xmx value passed is larger than the available memory.")
    public Boolean FORCE_GC = true;
    @Option(doc="Configure SortingCollections to store this many records before spilling to disk. For an indexed run, each SortingCollection gets this value/number of indices.")
    public int MAX_READS_IN_RAM_PER_TILE = 1200000;
    @Option(doc="The minimum quality (after transforming 0s to 1s) expected from reads.  If qualities are lower than this value, an error is thrown.The default of 2 is what the Illumina's spec describes as the minimum, but in practice the value has been observed lower.")
    public int MINIMUM_QUALITY = 2;
    @Option(doc="The read name header formatting to emit.  Casava1.8 formatting has additional information beyond Illumina, including: the passing-filter flag value for the read, the flowcell name, and the sequencer name.", optional=false)
    public ReadNameFormat READ_NAME_FORMAT = ReadNameFormat.CASAVA_1_8;
    private final Map<String, FastqRecordsWriter> barcodeFastqWriterMap = new HashMap<String, FastqRecordsWriter>();
    private ReadStructure readStructure;
    IlluminaBasecallsConverter<FastqRecordsForCluster> basecallsConverter;
    private static final Log log = Log.getInstance(IlluminaBasecallsToFastq.class);
    private final FastqWriterFactory fastqWriterFactory = new FastqWriterFactory();
    private ReadNameEncoder readNameEncoder;
    private static final Comparator<FastqRecordsForCluster> queryNameComparator = new Comparator<FastqRecordsForCluster>(){

        @Override
        public int compare(FastqRecordsForCluster fastqRecordsForCluster, FastqRecordsForCluster fastqRecordsForCluster2) {
            return SAMRecordQueryNameComparator.compareReadNames(fastqRecordsForCluster.templateRecords[0].getReadHeader(), fastqRecordsForCluster2.templateRecords[0].getReadHeader());
        }
    };

    @Override
    protected int doWork() {
        this.initialize();
        this.basecallsConverter.doTileProcessing();
        return 0;
    }

    @Override
    protected String[] customCommandLineValidation() {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (this.READ_NAME_FORMAT == ReadNameFormat.CASAVA_1_8 && this.MACHINE_NAME == null) {
            linkedList.add("MACHINE_NAME is required when using Casava1.8-style read name headers.");
        }
        if (this.READ_NAME_FORMAT == ReadNameFormat.CASAVA_1_8 && this.FLOWCELL_BARCODE == null) {
            linkedList.add("FLOWCELL_BARCODE is required when using Casava1.8-style read name headers.");
        }
        if (linkedList.isEmpty()) {
            return null;
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    private void initialize() {
        boolean bl;
        this.fastqWriterFactory.setCreateMd5(this.CREATE_MD5_FILE);
        switch (this.READ_NAME_FORMAT) {
            case CASAVA_1_8: {
                this.readNameEncoder = new Casava18ReadNameEncoder(this.MACHINE_NAME, this.RUN_BARCODE, this.FLOWCELL_BARCODE);
                break;
            }
            case ILLUMINA: {
                this.readNameEncoder = new IlluminaReadNameEncoder(this.RUN_BARCODE);
            }
        }
        BclQualityEvaluationStrategy bclQualityEvaluationStrategy = new BclQualityEvaluationStrategy(this.MINIMUM_QUALITY);
        this.readStructure = new ReadStructure(this.READ_STRUCTURE);
        if (this.MULTIPLEX_PARAMS != null) {
            IoUtil.assertFileIsReadable(this.MULTIPLEX_PARAMS);
        }
        if (this.OUTPUT_PREFIX != null) {
            this.barcodeFastqWriterMap.put(null, this.buildWriter(this.OUTPUT_PREFIX));
            bl = false;
        } else {
            this.populateWritersFromMultiplexParams();
            bl = true;
        }
        int n = this.readStructure.templates.length() + this.readStructure.barcodes.length();
        this.basecallsConverter = new IlluminaBasecallsConverter<FastqRecordsForCluster>(this.BASECALLS_DIR, this.LANE, this.readStructure, this.barcodeFastqWriterMap, bl, this.MAX_READS_IN_RAM_PER_TILE / n, this.TMP_DIR, this.NUM_PROCESSORS, this.FORCE_GC, this.FIRST_TILE, this.TILE_LIMIT, queryNameComparator, new FastqRecordsForClusterCodec(this.readStructure.templates.length(), this.readStructure.barcodes.length()), FastqRecordsForCluster.class, bclQualityEvaluationStrategy, this.APPLY_EAMSS_FILTER);
        log.info("READ STRUCTURE IS " + this.readStructure.toString());
        this.basecallsConverter.setConverter(new ClusterToFastqRecordsForClusterConverter());
    }

    private void assertExpectedColumns(Set<String> set, Set<String> set2) {
        HashSet<String> hashSet = new HashSet<String>(set2);
        hashSet.removeAll(set);
        if (hashSet.size() > 0) {
            throw new PicardException(String.format("MULTIPLEX_PARAMS file %s is missing the following columns: %s.", this.MULTIPLEX_PARAMS.getAbsolutePath(), StringUtil.join(", ", hashSet)));
        }
    }

    private void populateWritersFromMultiplexParams() {
        TabbedTextFileWithHeaderParser tabbedTextFileWithHeaderParser = new TabbedTextFileWithHeaderParser(this.MULTIPLEX_PARAMS);
        Set<String> set = CollectionUtil.makeSet("OUTPUT_PREFIX");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 1; i <= this.readStructure.barcodes.length(); ++i) {
            arrayList.add("BARCODE_" + i);
        }
        set.addAll(arrayList);
        this.assertExpectedColumns(tabbedTextFileWithHeaderParser.columnLabels(), set);
        for (TabbedTextFileWithHeaderParser.Row row : tabbedTextFileWithHeaderParser) {
            Object object;
            Iterator iterator;
            ArrayList<String> arrayList2 = null;
            if (arrayList.size() > 0) {
                arrayList2 = new ArrayList<String>();
                iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    object = (String)iterator.next();
                    arrayList2.add(row.getField((String)object));
                }
            }
            Iterator iterator2 = iterator = arrayList2 == null || arrayList2.contains("N") ? null : StringUtil.join("", arrayList2);
            if (this.barcodeFastqWriterMap.containsKey(iterator)) {
                throw new PicardException("Row for barcode " + iterator + " appears more than once in MULTIPLEX_PARAMS file " + this.MULTIPLEX_PARAMS);
            }
            object = this.buildWriter(new File(row.getField("OUTPUT_PREFIX")));
            this.barcodeFastqWriterMap.put((String)((Object)iterator), (FastqRecordsWriter)object);
        }
        if (this.barcodeFastqWriterMap.isEmpty()) {
            throw new PicardException("MULTIPLEX_PARAMS file " + this.MULTIPLEX_PARAMS + " does have any data rows.");
        }
    }

    private FastqRecordsWriter buildWriter(File file) {
        String string;
        int n;
        File file2 = file.getAbsoluteFile().getParentFile();
        IoUtil.assertDirectoryIsWritable(file2);
        String string2 = file.getName();
        FastqWriter[] fastqWriterArray = new FastqWriter[this.readStructure.templates.length()];
        FastqWriter[] fastqWriterArray2 = new FastqWriter[this.readStructure.barcodes.length()];
        for (n = 0; n < fastqWriterArray.length; ++n) {
            string = String.format("%s.%d.fastq", string2, n + 1);
            fastqWriterArray[n] = this.fastqWriterFactory.newWriter(new File(file2, string));
        }
        for (n = 0; n < fastqWriterArray2.length; ++n) {
            string = String.format("%s.barcode_%d.fastq", string2, n + 1);
            fastqWriterArray2[n] = this.fastqWriterFactory.newWriter(new File(file2, string));
        }
        return new FastqRecordsWriter(fastqWriterArray, fastqWriterArray2);
    }

    public static void main(String[] stringArray) {
        new IlluminaBasecallsToFastq().instanceMainWithExit(stringArray);
    }

    static class FastqRecordsForClusterCodec
    implements SortingCollection.Codec<FastqRecordsForCluster> {
        private final int numTemplates;
        private final int numBarcodes;
        private BasicFastqWriter writer = null;
        private FastqReader reader = null;

        FastqRecordsForClusterCodec(int n, int n2) {
            this.numTemplates = n;
            this.numBarcodes = n2;
        }

        @Override
        public void setOutputStream(OutputStream outputStream) {
            this.writer = new BasicFastqWriter(new PrintStream(outputStream));
        }

        @Override
        public void setInputStream(InputStream inputStream) {
            this.reader = new FastqReader(new BufferedReader(new InputStreamReader(inputStream)));
        }

        @Override
        public void encode(FastqRecordsForCluster fastqRecordsForCluster) {
            if (this.numTemplates != fastqRecordsForCluster.templateRecords.length) {
                throw new IllegalStateException();
            }
            if (this.numBarcodes != fastqRecordsForCluster.barcodeRecords.length) {
                throw new IllegalStateException();
            }
            this.encodeArray(fastqRecordsForCluster.templateRecords);
            this.encodeArray(fastqRecordsForCluster.barcodeRecords);
            this.writer.flush();
        }

        private void encodeArray(FastqRecord[] fastqRecordArray) {
            for (FastqRecord fastqRecord : fastqRecordArray) {
                this.writer.write(fastqRecord);
            }
        }

        @Override
        public FastqRecordsForCluster decode() {
            if (!this.reader.hasNext()) {
                return null;
            }
            FastqRecordsForCluster fastqRecordsForCluster = new FastqRecordsForCluster(this.numTemplates, this.numBarcodes);
            this.decodeArray(fastqRecordsForCluster.templateRecords);
            this.decodeArray(fastqRecordsForCluster.barcodeRecords);
            return fastqRecordsForCluster;
        }

        private void decodeArray(FastqRecord[] fastqRecordArray) {
            for (int i = 0; i < fastqRecordArray.length; ++i) {
                fastqRecordArray[i] = this.reader.next();
            }
        }

        @Override
        public SortingCollection.Codec<FastqRecordsForCluster> clone() {
            return new FastqRecordsForClusterCodec(this.numTemplates, this.numBarcodes);
        }
    }

    class ClusterToFastqRecordsForClusterConverter
    implements IlluminaBasecallsConverter.ClusterDataConverter<FastqRecordsForCluster> {
        private final int[] templateIndices;
        private final int[] barcodeIndices;

        ClusterToFastqRecordsForClusterConverter() {
            this.templateIndices = ((IlluminaBasecallsToFastq)IlluminaBasecallsToFastq.this).readStructure.templates.getIndices();
            this.barcodeIndices = ((IlluminaBasecallsToFastq)IlluminaBasecallsToFastq.this).readStructure.barcodes.getIndices();
        }

        @Override
        public FastqRecordsForCluster convertClusterToOutputRecord(ClusterData clusterData) {
            FastqRecordsForCluster fastqRecordsForCluster = new FastqRecordsForCluster(((IlluminaBasecallsToFastq)IlluminaBasecallsToFastq.this).readStructure.templates.length(), ((IlluminaBasecallsToFastq)IlluminaBasecallsToFastq.this).readStructure.barcodes.length());
            boolean bl = fastqRecordsForCluster.templateRecords.length > 1;
            this.makeFastqRecords(fastqRecordsForCluster.templateRecords, this.templateIndices, clusterData, bl);
            this.makeFastqRecords(fastqRecordsForCluster.barcodeRecords, this.barcodeIndices, clusterData, false);
            return fastqRecordsForCluster;
        }

        private void makeFastqRecords(FastqRecord[] fastqRecordArray, int[] nArray, ClusterData clusterData, boolean bl) {
            for (int n = 0; n < nArray.length; n = (int)((short)(n + 1))) {
                ReadData readData = clusterData.getRead(nArray[n]);
                String string = StringUtil.bytesToString(readData.getBases()).replace('.', 'N');
                String string2 = IlluminaBasecallsToFastq.this.readNameEncoder.generateReadName(clusterData, bl ? Integer.valueOf(n + 1) : null);
                fastqRecordArray[n] = new FastqRecord(string2, string, null, SAMUtils.phredToFastq(readData.getQualities()));
            }
        }
    }

    static class FastqRecordsForCluster {
        final FastqRecord[] templateRecords;
        final FastqRecord[] barcodeRecords;

        FastqRecordsForCluster(int n, int n2) {
            this.templateRecords = new FastqRecord[n];
            this.barcodeRecords = new FastqRecord[n2];
        }
    }

    private static class FastqRecordsWriter
    implements IlluminaBasecallsConverter.ConvertedClusterDataWriter<FastqRecordsForCluster> {
        final FastqWriter[] templateWriters;
        final FastqWriter[] barcodeWriters;

        private FastqRecordsWriter(FastqWriter[] fastqWriterArray, FastqWriter[] fastqWriterArray2) {
            this.templateWriters = fastqWriterArray;
            this.barcodeWriters = fastqWriterArray2;
        }

        @Override
        public void write(FastqRecordsForCluster fastqRecordsForCluster) {
            this.write(this.templateWriters, fastqRecordsForCluster.templateRecords);
            this.write(this.barcodeWriters, fastqRecordsForCluster.barcodeRecords);
        }

        private void write(FastqWriter[] fastqWriterArray, FastqRecord[] fastqRecordArray) {
            for (int i = 0; i < fastqWriterArray.length; ++i) {
                fastqWriterArray[i].write(fastqRecordArray[i]);
            }
        }

        @Override
        public void close() {
            for (FastqWriter fastqWriter : this.templateWriters) {
                fastqWriter.close();
            }
            for (FastqWriter fastqWriter : this.barcodeWriters) {
                fastqWriter.close();
            }
        }
    }

    public static enum ReadNameFormat {
        CASAVA_1_8,
        ILLUMINA;

    }
}

