/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina;

import java.util.List;
import net.sf.picard.fastq.IlluminaReadNameEncoder;
import net.sf.picard.fastq.ReadNameEncoder;
import net.sf.picard.filter.SamRecordFilter;
import net.sf.picard.filter.SolexaNoiseFilter;
import net.sf.picard.illumina.IlluminaBasecallsConverter;
import net.sf.picard.illumina.IlluminaBasecallsToSam;
import net.sf.picard.illumina.parser.ClusterData;
import net.sf.picard.illumina.parser.ReadData;
import net.sf.picard.illumina.parser.ReadStructure;
import net.sf.picard.util.AdapterPair;
import net.sf.picard.util.ClippingUtility;
import net.sf.picard.util.IlluminaUtil;
import net.sf.samtools.SAMRecord;

public class ClusterDataToSamConverter
implements IlluminaBasecallsConverter.ClusterDataConverter<IlluminaBasecallsToSam.SAMRecordsForCluster> {
    private final String runBarcode;
    private final String readGroupId;
    private final SamRecordFilter filters = new SolexaNoiseFilter();
    private final boolean isPairedEnd;
    private final boolean isBarcoded;
    private final int[] templateIndices;
    private final int[] barcodeIndices;
    private final AdapterPair[] adaptersToCheck;
    private final int outputRecordsPerCluster;
    private final ReadNameEncoder readNameEncoder;

    public ClusterDataToSamConverter(String string, String string2, ReadStructure readStructure, List<IlluminaUtil.IlluminaAdapterPair> list) {
        this.runBarcode = string;
        this.readGroupId = string2;
        this.readNameEncoder = new IlluminaReadNameEncoder(string);
        this.isPairedEnd = readStructure.templates.length() == 2;
        this.isBarcoded = !readStructure.barcodes.isEmpty();
        this.adaptersToCheck = new AdapterPair[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            this.adaptersToCheck[i] = list.get(i);
        }
        this.templateIndices = readStructure.templates.getIndices();
        this.barcodeIndices = readStructure.barcodes.getIndices();
        this.outputRecordsPerCluster = readStructure.templates.length();
    }

    private SAMRecord createSamRecord(ReadData readData, String string, boolean bl, boolean bl2, String string2) {
        SAMRecord sAMRecord = new SAMRecord(null);
        sAMRecord.setReadName(string);
        sAMRecord.setReadBases(readData.getBases());
        sAMRecord.setBaseQualities(readData.getQualities());
        sAMRecord.setReadPairedFlag(this.isPairedEnd);
        sAMRecord.setReadUnmappedFlag(true);
        sAMRecord.setReadFailsVendorQualityCheckFlag(!bl);
        if (this.isPairedEnd) {
            sAMRecord.setMateUnmappedFlag(true);
            sAMRecord.setFirstOfPairFlag(bl2);
            sAMRecord.setSecondOfPairFlag(!bl2);
        }
        if (this.filters.filterOut(sAMRecord)) {
            sAMRecord.setAttribute("XN", (Object)1);
        }
        if (this.readGroupId != null) {
            sAMRecord.setAttribute("RG", (Object)this.readGroupId);
        }
        if (string2 != null) {
            sAMRecord.setAttribute("BC", (Object)string2);
        }
        return sAMRecord;
    }

    @Override
    public IlluminaBasecallsToSam.SAMRecordsForCluster convertClusterToOutputRecord(ClusterData clusterData) {
        Object object;
        IlluminaBasecallsToSam.SAMRecordsForCluster sAMRecordsForCluster = new IlluminaBasecallsToSam.SAMRecordsForCluster(this.outputRecordsPerCluster);
        String string = this.readNameEncoder.generateReadName(clusterData, null);
        String string2 = null;
        if (this.isBarcoded && clusterData.getMatchedBarcode() == null) {
            object = new byte[this.barcodeIndices.length][];
            for (int i = 0; i < this.barcodeIndices.length; ++i) {
                object[i] = clusterData.getRead(this.barcodeIndices[i]).getBases();
            }
            string2 = IlluminaUtil.barcodeSeqsToString(object).replace('.', 'N');
        }
        object = this.createSamRecord(clusterData.getRead(this.templateIndices[0]), string, clusterData.isPf(), true, string2);
        sAMRecordsForCluster.records[0] = object;
        SAMRecord sAMRecord = null;
        if (this.isPairedEnd) {
            sAMRecordsForCluster.records[1] = sAMRecord = this.createSamRecord(clusterData.getRead(this.templateIndices[1]), string, clusterData.isPf(), false, string2);
        }
        if (this.adaptersToCheck.length > 0) {
            if (this.isPairedEnd) {
                ClippingUtility.adapterTrimIlluminaPairedReads((SAMRecord)object, sAMRecord, this.adaptersToCheck);
            } else {
                ClippingUtility.adapterTrimIlluminaSingleRead((SAMRecord)object, this.adaptersToCheck);
            }
        }
        return sAMRecordsForCluster;
    }
}

