/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.fastq;

import net.sf.picard.fastq.ReadNameEncoder;
import net.sf.picard.illumina.parser.ClusterData;
import net.sf.samtools.util.StringUtil;

public class Casava18ReadNameEncoder
implements ReadNameEncoder {
    static final int CONTROL_FIELD_VALUE = 0;
    final String runId;
    final String instrumentName;
    final String flowcellId;

    public Casava18ReadNameEncoder(String string, String string2, String string3) {
        this.runId = string2;
        this.instrumentName = string;
        this.flowcellId = string3;
    }

    @Override
    public String generateReadName(ClusterData clusterData, Integer n) {
        return String.format("%s:%s:%s:%d:%d:%d:%d %s:%s:%d:%s", new Object[]{this.instrumentName, this.runId, this.flowcellId, clusterData.getLane(), clusterData.getTile(), clusterData.getX(), clusterData.getY(), StringUtil.asEmptyIfNull(n), PassesFilterLabel.get(clusterData.isPf()), 0, StringUtil.asEmptyIfNull(clusterData.getMatchedBarcode())});
    }

    static enum PassesFilterLabel {
        Y,
        N;


        static PassesFilterLabel get(boolean bl) {
            return bl ? Y : N;
        }
    }
}

