library(ROCR)
df = read.table("~/Downloads/insight_cadd_missenseonly.tsv", header=T, sep="\t")
dfSub <- subset(df, InSiGHT_Class == "Class 1" | InSiGHT_Class == "Class 2" | InSiGHT_Class == "Class 4" | InSiGHT_Class == "Class 5")
dfSub$InSiGHT_Class[dfSub$InSiGHT_Class %in% "Class 2"] <- "Class 1"
dfSub$InSiGHT_Class[dfSub$InSiGHT_Class %in% "Class 4"] <- "Class 5"
dfSub$InSiGHT_Class = factor(dfSub$InSiGHT_Class)
pred <- prediction(dfSub$CADD_phred, dfSub$InSiGHT_Class)
performance(pred, "auc")

