/*
 * Decompiled with CFR 0.152.
 */
package jfig.objects;

import java.awt.Color;
import java.awt.Graphics;
import jfig.canvas.FigTrafo2D;
import jfig.gui.ColorCache;
import jfig.objects.FigAttribs;
import jfig.objects.FigBaseobject;
import jfig.objects.FigBbox;
import jfig.objects.FigObject;
import jfig.objects.FigObjectFactory;
import jfig.objects.FigObjectVisitor;
import jfig.objects.FigRenderer;
import jfig.objects.Point;

public class FigRectangle
extends FigBaseobject {
    protected FigRenderer renderer;
    protected boolean use_rounded_corners;
    protected double radius;
    protected int pixel_width;

    public void createRenderer() {
        this.renderer = FigObjectFactory.getDefaultObjectFactory().createRectangleRenderer(this);
        this.needsRebuild = false;
    }

    public void rebuild() {
        this.createRenderer();
    }

    public void setAttributes(FigAttribs figAttribs) {
        super.setAttributes(figAttribs);
        this.needsRebuild = true;
    }

    public void setLayer(int n) {
        this.attribs.currentLayer = n;
        this.needsRebuild = true;
    }

    public void setLineColor(Color color) {
        int n;
        this.attribs.fig_line_color = n = ColorCache.getColorCache().registerUserColor(color);
        this.attribs.lineColor = color;
        this.needsRebuild = true;
    }

    public void setLineWidth(int n) {
        this.attribs.setFigLineWidth(n);
        this.needsRebuild = true;
    }

    public void setLineStyle(int n) {
        this.attribs.lineStyle = n;
        this.needsRebuild = true;
    }

    public void setFillColor(Color color) {
        int n;
        this.attribs.fig_fill_color = n = ColorCache.getColorCache().registerUserColor(color);
        this.attribs.fillColor = color;
        this.needsRebuild = true;
    }

    public void setFillStyle(int n) {
        if (n < 0) {
            this.attribs.fillStyle = 1;
        } else if (n < 41) {
            this.attribs.fillStyle = 2;
            this.attribs.fig_area_fill = n;
        } else if (n <= 56) {
            this.attribs.fillStyle = 3;
            this.attribs.fig_area_fill = n;
        } else {
            this.message("setFillStyle: value out of range: " + n);
        }
        this.needsRebuild = true;
    }

    public boolean isRounded() {
        return this.use_rounded_corners;
    }

    public void setRoundedCorners(boolean bl) {
        this.use_rounded_corners = bl;
    }

    public Point[] getPoints() {
        Point[] pointArray = new Point[]{new Point(this.bbox.getXl(), this.bbox.getYt()), new Point(this.bbox.getXr(), this.bbox.getYb())};
        return pointArray;
    }

    public void setPoints(Point[] pointArray) {
        if (pointArray == null || pointArray.length < 2 || pointArray.length > 3) {
            this.message("-E- a rectangle needs 2 Points for setPoints()");
            return;
        }
        this.bbox.set(pointArray[0].x, pointArray[0].y, pointArray[1].x, pointArray[1].y);
        this.x = this.bbox.getXl();
        this.y = this.bbox.getYt();
        this.needsRebuild = true;
    }

    public void update(FigAttribs figAttribs) {
        if (this.debug) {
            this.message("FigRectangle.update()...");
        }
        this.attribs.update(figAttribs);
        this.needsRebuild = true;
    }

    public FigObject copy() {
        if (this.debug) {
            this.message("FigRectangle.copy()...");
        }
        FigRectangle figRectangle = new FigRectangle(this.bbox.getXl(), this.bbox.getYt(), this.bbox.getXr(), this.bbox.getYb(), this.use_rounded_corners, this.attribs.getClone());
        return figRectangle;
    }

    public void move(double d, double d2) {
        this.bbox = new FigBbox(this.bbox.getXl() + d, this.bbox.getYt() + d2, this.bbox.getXr() + d, this.bbox.getYb() + d2);
        this.x = this.bbox.getXl();
        this.y = this.bbox.getYt();
        this.needsRebuild = true;
    }

    public void mirrorX(double d, double d2) {
        Point[] pointArray = this.getPoints();
        pointArray[0].x = (double)2 * d - pointArray[0].x;
        pointArray[1].x = (double)2 * d - pointArray[1].x;
        this.setPoints(pointArray);
        this.needsRebuild = true;
    }

    public void mirrorY(double d, double d2) {
        Point[] pointArray = this.getPoints();
        pointArray[0].y = (double)2 * d2 - pointArray[0].y;
        pointArray[1].y = (double)2 * d2 - pointArray[1].y;
        this.setPoints(pointArray);
        this.needsRebuild = true;
    }

    public boolean canRotate(double d) {
        int n = (int)(180.0 * Math.abs(d) / Math.PI + 0.5);
        boolean bl = false;
        if (n % 90 == 0) {
            bl = true;
        }
        return bl;
    }

    public boolean supportsPointOps() {
        return true;
    }

    public boolean isClosed() {
        return true;
    }

    public void appendPoint(Point point) {
    }

    public Point deletePoint(Point point) {
        return null;
    }

    public void insertPoint(Point point, Point point2) {
    }

    public Point[] getMovePointNeighbors(Point point) {
        double d = Math.abs(point.x - this.bbox.getXl()) < Math.abs(point.x - this.bbox.getXr()) ? this.bbox.getXr() : this.bbox.getXl();
        double d2 = Math.abs(point.y - this.bbox.getYt()) < Math.abs(point.y - this.bbox.getYb()) ? this.bbox.getYb() : this.bbox.getYt();
        Point point2 = new Point(d, d2);
        Point[] pointArray = new Point[]{point2};
        return pointArray;
    }

    public void movePoint(Point point, Point point2) {
        double d = Math.abs(point.x - this.bbox.getXl());
        double d2 = Math.abs(point.x - this.bbox.getXr());
        double d3 = Math.abs(point.y - this.bbox.getYt());
        double d4 = Math.abs(point.y - this.bbox.getYb());
        double d5 = d < d2 ? this.bbox.getXr() : this.bbox.getXl();
        double d6 = d3 < d4 ? this.bbox.getYb() : this.bbox.getYt();
        Point point3 = new Point(d5, d6);
        this.bbox.set(point2.x, point2.y, point3.x, point3.y);
        this.x = this.bbox.getXl();
        this.y = this.bbox.getYt();
        this.needsRebuild = true;
    }

    public Point getNearestPoint(Point point) {
        double d = Math.abs(point.x - this.bbox.getXl());
        double d2 = Math.abs(point.x - this.bbox.getXr());
        double d3 = Math.abs(point.y - this.bbox.getYt());
        double d4 = Math.abs(point.y - this.bbox.getYb());
        double d5 = d > d2 ? this.bbox.getXr() : this.bbox.getXl();
        double d6 = d3 > d4 ? this.bbox.getYb() : this.bbox.getYt();
        return new Point(d5, d6);
    }

    public Point[] getNeighborPoints(Point point) {
        Point[] pointArray = new Point[]{point, point, point};
        return pointArray;
    }

    public double minDistance(Point point, double d) {
        return this.bbox.minDistanceInside(point);
    }

    public double minDistanceEuclid(Point point, double d) {
        double d2 = this.bbox.minDistance(point);
        if (this.bbox.isInside(point)) {
            d2 = Math.min(d2, 0.4 * d);
        }
        return d2;
    }

    public void paint(Graphics graphics, FigTrafo2D figTrafo2D) {
        if (this.needsRebuild) {
            this.createRenderer();
        }
        this.renderer.paint(graphics, figTrafo2D);
    }

    public void paintSave(Graphics graphics, FigTrafo2D figTrafo2D) {
        if (this.needsRebuild) {
            this.createRenderer();
        }
        Graphics graphics2 = graphics.create();
        this.renderer.paint(graphics2, figTrafo2D);
        graphics2.dispose();
    }

    public void accept(FigObjectVisitor figObjectVisitor) {
        figObjectVisitor.visit(this);
    }

    public String toString() {
        String string = "FigRectangle  " + this.bbox + " layer " + this.attribs.currentLayer + " colors " + this.attribs.lineColor + ' ' + this.attribs.fillColor;
        return string;
    }

    public FigRectangle() {
        this(0.0, 0.0, 2400.0, 2400.0, 10);
    }

    public FigRectangle(FigBbox figBbox, int n) {
        this(figBbox.getXl(), figBbox.getYt(), figBbox.getXr(), figBbox.getYb(), n);
    }

    public FigRectangle(double d, double d2, double d3, double d4, int n) {
        double d5;
        if (d > d3) {
            d5 = d3;
            d3 = d;
            d = d5;
        }
        if (d2 > d4) {
            d5 = d4;
            d4 = d2;
            d2 = d5;
        }
        this.x = d;
        this.y = d2;
        this.attribs.currentLayer = n;
        this.attribs.cornerRadius = 0.0;
        this.bbox.set(d, d2, d3, d4);
        this.needsRebuild = true;
    }

    public FigRectangle(double d, double d2, double d3, double d4, boolean bl, FigAttribs figAttribs) {
        this(d, d2, d3, d4, figAttribs.currentLayer);
        this.attribs = figAttribs;
        this.use_rounded_corners = bl;
        if (!bl) {
            this.attribs.cornerRadius = 0.0;
        }
    }
}

